<?php
/**
* @version	$Id: spam_report_eh.php 15165 2012-03-09 10:24:24Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2011 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class SpamReportEventHandler extends kDBEventHandler {

	/**
	 * Allows to override standard permission mapping
	 *
	 * @return void
	 * @access protected
	 * @see kEventHandler::$permMapping
	 */
	protected function mapPermissions()
	{
		parent::mapPermissions();

		$permissions = Array (
			'OnNewReport' => Array ('self' => true),
			'OnDeleteAssocItem' => Array ('self' => 'delete'),
		);

		$this->permMapping = array_merge($this->permMapping, $permissions);
	}

	/**
	 * Checks permissions
	 *
	 * @param kEvent $event
	 */
//	function CheckPermission($event)
//	{
//		if ( $event->Name == 'OnNewReport' ) {
//			$perm_helper = $this->Application->recallObject('PermissionsHelper');
//			/* @var $perm_helper kPermissionsHelper */
//
//			return $perm_helper->finalizePermissionCheck($event, $this->Application->LoggedIn());
//		}
//
//		return parent::CheckPermission($event);
//	}

	/**
	 * Prefills missing fields
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnBeforeItemCreate(kEvent $event)
	{
		parent::OnBeforeItemCreate($event);

		$object = $event->getObject();
		/* @var $object kDBItem */

		$item_prefix = $this->Application->GetVar('item_prefix');
		$item_id = $this->Application->GetVar($item_prefix . '_id');

		if ( $item_id ) {
			$object->SetDBField('ItemPrefix', $item_prefix);
			$object->SetDBField('ItemId', $item_id);
		}

		$object->SetDBField('ReportedById', $this->Application->RecallVar('user_id'));
	}

	/**
	 * Send e-mail after new spam report was created
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnAfterItemCreate(kEvent $event)
	{
		parent::OnAfterItemCreate($event);

		$object = $event->getObject();
		/* @var $object kDBItem */

		$item_prefix = $object->GetDBField('ItemPrefix');

		if ( preg_match('/rev$/', $item_prefix) ) {
			$item = $this->Application->recallObject($item_prefix);
			/* @var $item kDBItem */

			$object->SetDBField('ItemName', $item->GetDBField('ReviewText'));
		}

		$this->Application->EmailEventAdmin('SPAM.REPORT');
	}

	/**
	 * Sends new spam report
	 *
	 * @param kEvent $event
	 */
	function OnNewReport($event)
	{
		$ajax_form_helper = $this->Application->recallObject('AjaxFormHelper');
		/* @var $ajax_form_helper AjaxFormHelper */

		$ajax_form_helper->transitEvent($event, 'OnCreate');
	}

	/**
	 * Deletes item, associated with given spam report
	 *
	 * @param kEvent $event
	 */
	function OnDeleteAssocItem($event)
	{
		$temp_handlers = Array ();
		$ids = $this->StoreSelectedIDs($event);

		$object = $event->getObject( Array ('skip_autoload' => true) );
		/* @var $object kDBItem */

		foreach ($ids as $id) {
			$object->Load($id);
			$item_prefix = $object->GetDBField('ItemPrefix');

			if ( !isset($temp_handlers[$item_prefix]) ) {
				$temp_handlers[$item_prefix] = $this->Application->recallObject($item_prefix . '_TempHandler', 'kTempTablesHandler');
			}

			$temp_handlers[$item_prefix]->DeleteItems($item_prefix, '', Array ($object->GetDBField('ItemId')));
		}

		$this->clearSelectedIDs($event);

		$event->SetRedirectParam('opener', 'u');
	}
}