<?php
/**
* @version	$Id: upload_formatter.php 15137 2012-03-04 08:06:21Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2011 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class kUploadFormatter extends kFormatter
{
	var $DestinationPath;
	var $FullPath;

	/**
	 * File helper reference
	 *
	 * @var FileHelper
	 */
	var $fileHelper = null;

	public function __construct()
	{
		parent::__construct();

		$this->fileHelper = $this->Application->recallObject('FileHelper');

		if ($this->DestinationPath) {
			$this->FullPath = FULL_PATH.$this->DestinationPath;
		}
	}

	/**
	 * Processes file uploads from form
	 *
	 * @param mixed $value
	 * @param string $field_name
	 * @param kDBItem $object
	 * @return mixed
	 * @access public
	 */
	public function Parse($value, $field_name, &$object)
	{
		$ret = !is_array($value) ? $value : '';
		$options = $object->GetFieldOptions($field_name);

		if (getArrayValue($options, 'upload_dir')) {
			$this->DestinationPath = $options['upload_dir'];
			$this->FullPath = FULL_PATH.$this->DestinationPath;
		}

		// SWF Uploader
		if (is_array($value) && isset($value['tmp_ids'])) {
			if ($value['tmp_deleted']) {
				$deleted = explode('|', $value['tmp_deleted']);
				$upload = explode('|', $value['upload']);
				$n_upload = array();
//				$n_ids = array();
				foreach ($upload as $name) {
					if (in_array($name, $deleted)) continue;
					$n_upload[] = $name;
//					$n_ids[] = $name;
				}
				$value['upload'] = implode('|', $n_upload);
//				$value['tmp_ids'] = implode('|', $n_ids);
			}

			if (!$value['tmp_ids']) {
				// no pending files -> return already uploded files
				return getArrayValue($value, 'upload');
			}
			$swf_uploaded_ids = explode('|', $value['tmp_ids']);
			$swf_uploaded_names = explode('|', $value['tmp_names']);
			$existing = $value['upload'] ? explode('|', $value['upload']) : array();
			if (isset($options['multiple'])) {
				$max_files = $options['multiple'] == false ? 1 : $options['multiple'];
			}
			else {
				$max_files = 1;
			}
			$fret = array();

			// don't delete uploaded file, when it's name matches delete file name
			$var_name = $object->getPrefixSpecial().'_file_pending_actions'.$this->Application->GetVar('m_wid');
			$schedule = $this->Application->RecallVar($var_name);
			$schedule = $schedule ? unserialize($schedule) : Array();
			$files2delete = Array();
			foreach ($schedule as $data) {
				if ($data['action'] == 'delete') {
					$files2delete[] = $data['file'];
				}
			}

			for ($i = 0; $i < min($max_files, count($swf_uploaded_ids)); $i++) {
				$real_name = $this->getStorageEngineFile($swf_uploaded_names[$i], $options, $object->Prefix);
				$real_name = $this->getStorageEngineFolder($real_name, $options) . $real_name;

				$real_name = $this->fileHelper->ensureUniqueFilename($this->FullPath, $real_name, $files2delete);
				$file_name = $this->FullPath . $real_name;

				$tmp_file = WRITEABLE . '/tmp/' . $swf_uploaded_ids[$i] . '_' . $swf_uploaded_names[$i];
				rename($tmp_file, $file_name);

				@chmod($file_name, 0666);
				$fret[] = getArrayValue($options, 'upload_dir') ? $real_name : $this->DestinationPath . $real_name;
			}

			return implode('|', array_merge($existing, $fret));
		}

		// SWF Uploader END

		if (getArrayValue($value, 'upload') && getArrayValue($value, 'error') == UPLOAD_ERR_NO_FILE) {
			// file was not uploaded this time, but was uploaded before, then use previously uploaded file (from db)
			return getArrayValue($value, 'upload');
		}

		if (is_array($value) && count($value) > 1 && $value['size']) {
			if (is_array($value) && $value['error'] === UPLOAD_ERR_OK) {
				$max_filesize = isset($options['max_size']) ? $options['max_size'] : MAX_UPLOAD_SIZE;

				// we can get mime type based on file content and no use one, provided by the client
//				$value['type'] = kUtil::mimeContentType($value['tmp_name']);

				if ( getArrayValue($options, 'file_types') && !$this->extensionMatch($value['name'], $options['file_types']) ) {
					// match by file extensions
					$error_params = Array (
						'file_name' => $value['name'],
						'file_types' => $options['file_types'],
					);

					$object->SetError($field_name, 'bad_file_format', 'la_error_InvalidFileFormat', $error_params);
				}
				elseif ( getArrayValue($options, 'allowed_types') && !in_array($value['type'], $options['allowed_types']) ) {
					// match by mime type provided by web-browser
					$error_params = Array (
						'file_type' => $value['type'],
						'allowed_types' => $options['allowed_types'],
					);

					$object->SetError($field_name, 'bad_file_format', 'la_error_InvalidFileFormat', $error_params);
				}
				elseif ( $value['size'] > $max_filesize ) {
					$object->SetError($field_name, 'bad_file_size', 'la_error_FileTooLarge');
				}
				elseif ( !is_writable($this->FullPath) ) {
					$object->SetError($field_name, 'cant_save_file', 'la_error_cant_save_file');
				}
				else {
					$real_name = $this->getStorageEngineFile($value['name'], $options, $object->Prefix);
					$real_name = $this->getStorageEngineFolder($real_name, $options) . $real_name;

					$real_name = $this->fileHelper->ensureUniqueFilename($this->FullPath, $real_name);
					$file_name = $this->FullPath . $real_name;

					$storage_format = isset($options['storage_format']) ? $options['storage_format'] : false;

					if ( $storage_format ) {
						$image_helper = $this->Application->recallObject('ImageHelper');
						/* @var $image_helper ImageHelper */

						move_uploaded_file($value['tmp_name'], $value['tmp_name'] . '.jpg'); // add extension, so ResizeImage can work
						$url = $image_helper->ResizeImage($value['tmp_name'] . '.jpg', $storage_format);
						$tmp_name = preg_replace('/^' . preg_quote($this->Application->BaseURL(), '/') . '/', '/', $url);
						$moved = rename($tmp_name, $file_name);
					}
					else {
						$moved = move_uploaded_file($value['tmp_name'], $file_name);
					}

					if ( !$moved ) {
						$object->SetError($field_name, 'cant_save_file', 'la_error_cant_save_file');
					}
					else {
						@chmod($file_name, 0666);

						if ( getArrayValue($options, 'size_field') ) {
							$object->SetDBField($options['size_field'], $value['size']);
						}

						if ( getArrayValue($options, 'orig_name_field') ) {
							$object->SetDBField($options['orig_name_field'], $value['name']);
						}

						if ( getArrayValue($options, 'content_type_field') ) {
							$object->SetDBField($options['content_type_field'], $value['type']);
						}

						$ret = getArrayValue($options, 'upload_dir') ? $real_name : $this->DestinationPath . $real_name;

						// delete previous file, when new file is uploaded under same field
						/*$previous_file = isset($value['upload']) ? $value['upload'] : false;
						if ($previous_file && file_exists($this->FullPath.$previous_file)) {
							unlink($this->FullPath.$previous_file);
						}*/
					}
				}
			}
			else {
				$object->SetError($field_name, 'cant_save_file', 'la_error_cant_save_file');
			}
		}

		if ( (count($value) > 1) && $value['error'] && ($value['error'] != UPLOAD_ERR_NO_FILE) ) {
			$object->SetError($field_name, 'cant_save_file', 'la_error_cant_save_file', $value);
		}

		return $ret;
	}

	/**
	 * Checks, that given file name has on of provided file extensions
	 *
	 * @param string $filename
	 * @param string $file_types
	 * @return bool
	 * @access protected
	 */
	protected function extensionMatch($filename, $file_types)
	{
		if ( preg_match_all('/\*\.(.*?)(;|$)/', $file_types, $regs) ) {
			$file_extension = mb_strtolower( pathinfo($filename, PATHINFO_EXTENSION) );
			$file_extensions = array_map('mb_strtolower', $regs[1]);

			return in_array($file_extension, $file_extensions);
		}

		return true;
	}

	function getSingleFormat($format)
	{
		$single_mapping = Array (
			'file_urls' => 'full_url',
			'file_paths' => 'full_path',
			'file_sizes' => 'file_size',
			'files_resized' => 'resize',
			'img_sizes' => 'img_size',
			'wms' => 'wm',
		);

		return $single_mapping[$format];
	}

	/**
	 * Return formatted file url,path or size (or same for multiple files)
	 *
	 * @param string $value
	 * @param string $field_name
	 * @param kDBItem|kDBList $object
	 * @param string $format
	 * @return string
	 */
	function Format($value, $field_name, &$object, $format = null)
	{
		if (is_null($value)) {
			return '';
		}

		$options = $object->GetFieldOptions($field_name);
		if (!isset($format)) {
			$format = isset($options['format']) ? $options['format'] : false;
		}

		if ($format && preg_match('/(file_urls|file_paths|file_names|file_sizes|img_sizes|files_resized|wms)(.*)/', $format, $regs)) {
			if (!$value || $format == 'file_names') {
				// storage format matches display format OR no value
				return $value;
			}

			$ret = Array ();
			$files = explode('|', $value);
			$format = $this->getSingleFormat($regs[1]).$regs[2];

			foreach ($files as $a_file) {
				$ret[] = $this->GetFormatted($a_file, $field_name, $object, $format);
			}

			return implode('|', $ret);
		}

		$tc_value = $this->TypeCast($value, $options);
		if( ($tc_value === false) || ($tc_value != $value) ) return $value; // for leaving badly formatted date on the form

		// force direct links for case, when non-swf uploader is used
		return $this->GetFormatted($tc_value, $field_name, $object, $format, true);
	}

	/**
	 * Return formatted file url,path or size
	 *
	 * @param string $value
	 * @param string $field_name
	 * @param kDBItem $object
	 * @param string $format
	 * @param bool $force_direct_links
	 * @return string
	 */
	function GetFormatted($value, $field_name, &$object, $format = null, $force_direct_links = null)
	{
		if (!$format) {
			return $value;
		}

		$options = $object->GetFieldOptions($field_name);
		$upload_dir = isset($options['upload_dir']) ? $options['upload_dir'] : $this->DestinationPath;

		if (preg_match('/resize:([\d]*)x([\d]*)/', $format, $regs)) {
			$image_helper = $this->Application->recallObject('ImageHelper');
			/* @var $image_helper ImageHelper */

			if (array_key_exists('include_path', $options) && $options['include_path']) {
				// relative path is already included in field
				$upload_dir = '';
			}

			return $image_helper->ResizeImage($value ? FULL_PATH . str_replace('/', DIRECTORY_SEPARATOR, $upload_dir) . $value : '', $format);
		}

		switch ($format) {
			case 'full_url':
				if ( isset($force_direct_links) ) {
					$direct_links = $force_direct_links;
				}
				else {
					$direct_links = isset($options['direct_links']) ? $options['direct_links'] : false;
				}

				if ( $direct_links ) {
					return $this->fileHelper->pathToUrl(FULL_PATH . $upload_dir . $value);
				}
				else {
					$url_params = Array (
						'no_amp' => 1, 'pass' => 'm,'.$object->Prefix,
						$object->Prefix . '_event' => 'OnViewFile',
						'file' => rawurlencode($value), 'field' => $field_name
					);

					return $this->Application->HREF('', '', $url_params);
				}
				break;

			case 'full_path':
				return FULL_PATH . str_replace('/', DIRECTORY_SEPARATOR, $upload_dir) . $value;
				break;

			case 'file_size':
				return filesize(FULL_PATH . str_replace('/', DIRECTORY_SEPARATOR, $upload_dir) . $value);
				break;

			case 'img_size':
				$image_helper = $this->Application->recallObject('ImageHelper');
				/* @var $image_helper ImageHelper */

				$image_info = $image_helper->getImageInfo(FULL_PATH . str_replace('/', DIRECTORY_SEPARATOR, $upload_dir) . $value);
				return $image_info ? $image_info[3] : '';
				break;
		}

		return sprintf($format, $value);
	}

	/**
	 * Creates & returns folder, based on storage engine specified in field options
	 *
	 * @param string $file_name
	 * @param array $options
	 * @return string
	 * @access protected
	 */
	protected function getStorageEngineFolder($file_name, $options)
	{
		$storage_engine = (string)getArrayValue($options, 'storage_engine');

		if ( !$storage_engine ) {
			return '';
		}

		switch ($storage_engine) {
			case StorageEngine::HASH:
				$folder_path = kUtil::getHashPathForLevel($file_name);
				break;

			case StorageEngine::TIMESTAMP:
				$folder_path = adodb_date('Y-m/d/');
				break;

			default:
				throw new Exception('Unknown storage engine "<strong>' . $storage_engine . '</strong>".');
				break;
		}

		return $folder_path;
	}

	/**
	 * Applies prefix & suffix to uploaded filename, based on storage engine in field options
	 *
	 * @param string $name
	 * @param array $options
	 * @param string $unit_prefix
	 * @return string
	 * @access protected
	 */
	protected function getStorageEngineFile($name, $options, $unit_prefix)
	{
		$prefix = $this->getStorageEngineFilePart(getArrayValue($options, 'filename_prefix'), $unit_prefix);
		$suffix = $this->getStorageEngineFilePart(getArrayValue($options, 'filename_suffix'), $unit_prefix);

		$parts = pathinfo($name);

		return ($prefix ? $prefix . '_' : '') . $parts['filename'] . ($suffix ? '_' . $suffix : '') . '.' . $parts['extension'];
	}

	/**
	 * Creates prefix/suffix to join with uploaded file
	 *
	 * Added "u" before user_id to keep this value after FileHelper::ensureUniqueFilename method call
	 *
	 * @param string $option
	 * @param string $unit_prefix
	 * @return string
	 * @access protected
	 */
	protected function getStorageEngineFilePart($option, $unit_prefix)
	{
		$replace_from = Array (
			StorageEngine::PS_DATE_TIME, StorageEngine::PS_PREFIX, StorageEngine::PS_USER
		);

		$replace_to = Array (
			adodb_date('Ymd-His'), $unit_prefix, 'u' . $this->Application->RecallVar('user_id')
		);

		return str_replace($replace_from, $replace_to, $option);
	}
}

class kPictureFormatter extends kUploadFormatter
{
	public function __construct()
	{
		$this->NakeLookupPath = IMAGES_PATH; // used ?
		$this->DestinationPath = kUtil::constOn('ADMIN') ? IMAGES_PENDING_PATH : IMAGES_PATH;

		parent::__construct();
	}

	function GetFormatted($value, $field_name, &$object, $format = null, $force_direct_links = null)
	{
		if ($format == 'img_size') {
			$upload_dir = isset($options['upload_dir']) ? $options['upload_dir'] : $this->DestinationPath;
			$img_path = FULL_PATH.'/'.$upload_dir.$value;

			$image_info = @getimagesize($img_path);
			return ' width="'.$image_info[0].'" height="'.$image_info[1].'"';
		}

		return parent::GetFormatted($value, $field_name, $object, $format, $force_direct_links);
	}
}