<?php
/**
* @version	$Id: scheduled_task_eh.php 15145 2012-03-04 09:04:08Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class ScheduledTaskEventHandler extends kDBEventHandler {

		/**
		 * Allows to override standard permission mapping
		 *
		 * @return void
		 * @access protected
		 * @see kEventHandler::$permMapping
		 */
		protected function mapPermissions()
		{
			parent::mapPermissions();

			$permissions = Array (
				'OnMassCancel' => Array ('self' => 'add|edit'),
				'OnRun' => Array ('self' => 'add|edit'),
			);

			$this->permMapping = array_merge($this->permMapping, $permissions);
		}

		/**
		 * [HOOK] Refreshes scheduled task list in database based on cached data from unit configs
		 *
		 * @param kEvent $event
		 */
		function OnRefresh($event)
		{
			$scheduled_tasks_from_cache = $this->Application->EventManager->getScheduledTasks(true);

			$object = $event->getObject( Array ('skip_autoload' => true) );
			/* @var $object kDBItem */

			$processed_ids = Array ();
			$scheduled_tasks_from_db = $this->Conn->Query($object->GetSelectSQL(), 'Name');

			foreach ($scheduled_tasks_from_cache as $scheduled_task_name => $scheduled_task_params) {
				if ( !isset($scheduled_tasks_from_db[$scheduled_task_name]) ) {
					$fields_hash = Array (
						'Event' => $scheduled_task_params['Event'],
						'Name' => $scheduled_task_name,
						'Type' => ScheduledTask::TYPE_SYSTEM,
						'Status' => isset($scheduled_task_params['Status']) ? $scheduled_task_params['Status'] : STATUS_ACTIVE,
						'RunInterval' => $scheduled_task_params['RunInterval'],
					);

					$object->Clear();
					$object->SetDBFieldsFromHash($fields_hash);
					$object->Create();
				}
				else {
					$object->LoadFromHash( $scheduled_tasks_from_db[$scheduled_task_name] );
				}

				$processed_ids[] = $object->GetID();
			}

			// delete all non-processed scheduled tasks (ones, that were deleted from unit configs)
			$sql = 'SELECT ' . $object->IDField . '
					FROM ' . $object->TableName . '
					WHERE (Type = ' . ScheduledTask::TYPE_SYSTEM . ') AND (' . $object->IDField . ' NOT IN (' . implode(',', $processed_ids) . '))';
			$delete_ids = $this->Conn->GetCol($sql);

			if ($delete_ids) {
				$temp_handler = $this->Application->recallObject($event->getPrefixSpecial().'_TempHandler', 'kTempTablesHandler');
				/* @var $temp_handler kTempTablesHandler */

				$temp_handler->DeleteItems($event->Prefix, $event->Special, $delete_ids);
			}

			$this->Application->removeObject($event->getPrefixSpecial());
		}

		/**
		 * Don't allow to delete other user's messages
		 *
		 * @param kEvent $event
		 * @param string $type
		 * @return void
		 * @access protected
		 */
		protected function customProcessing(kEvent $event, $type)
		{
			if ( $event->Name == 'OnMassDelete' && $type == 'before' ) {
				if ( $this->Application->isDebugMode() ) {
					// allow to delete system scheduled tasks in debug mode
					return;
				}

				$ids = $event->getEventParam('ids');

				if ( $ids ) {
					$id_field = $this->Application->getUnitOption($event->Prefix, 'IDField');
					$table_name = $this->Application->getUnitOption($event->Prefix, 'TableName');

					$sql = 'SELECT ' . $id_field . '
							FROM ' . $table_name . '
							WHERE ' . $id_field . ' IN (' . implode(',', $ids) . ') AND Type <> ' . ScheduledTask::TYPE_SYSTEM;
					$event->setEventParam('ids', $this->Conn->GetCol($sql));
				}
			}
		}

		/**
		 * Cancels scheduled tasks, that are currently running
		 *
		 * @param kEvent $event
		 */
		function OnMassCancel($event)
		{
			$ids = $this->StoreSelectedIDs($event);

			if ($ids) {
				$object = $event->getObject( Array ('skip_autoload' => true) );
				/* @var $object kDBItem */

				foreach ($ids as $id) {
					$object->Load($id);

					if ($object->GetDBField('LastRunStatus') == ScheduledTask::LAST_RUN_RUNNING) {
						// only changes status, doesn't affect currency running scheduled tasks
						$object->SetDBField('LastRunStatus', ScheduledTask::LAST_RUN_FAILED);
						$object->Update();
					}
				}
			}

			$this->clearSelectedIDs($event);
		}

		/**
		 * Runs selected scheduled tasks
		 *
		 * @param kEvent $event
		 */
		function OnRun($event)
		{
			$ids = $this->StoreSelectedIDs($event);

			if ($ids) {
				$object = $event->getObject( Array ('skip_autoload' => true) );
				/* @var $object kDBItem */

				$where_clause = Array (
					$object->TableName . '.' . $object->IDField . ' IN (' . implode(',', $ids) . ')',
					$object->TableName . '.Status = ' . STATUS_ACTIVE,
					$object->TableName . '.LastRunStatus <> ' . ScheduledTask::LAST_RUN_RUNNING,
				);

				$sql =	$object->GetSelectSQL() . '
						WHERE (' . implode(') AND (', $where_clause) . ')';
				$scheduled_tasks = $this->Conn->Query($sql);

				foreach ($scheduled_tasks as $scheduled_task_data) {
					$scheduled_task_data['EventName'] = $scheduled_task_data['Event'];
					$this->Application->EventManager->runScheduledTask($scheduled_task_data);
				}
			}

			$this->clearSelectedIDs($event);
		}
	}