<?php
/**
* @version	$Id: user_groups_eh.php 15065 2012-01-17 15:11:29Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class UserGroupsEventHandler extends kDBEventHandler {

		/**
		 * Adds user as member for selected groups
		 *
		 * @param kEvent $event
		 */
		function OnProcessSelected(&$event)
		{
			if ($event->Prefix == 'u-ug') {
				$new_groups = $this->Application->GetVar('g');
				if (!$new_groups) {
					return ;
				}

				$new_groups = array_keys($new_groups);

				// don't insert duplicate group membership record
				$user_id = $this->Application->GetVar('u_id');
				$table_name = $this->Application->GetTempName(TABLE_PREFIX.'UserGroupRelations', 'prefix:u');

				$sql = 'SELECT GroupId
						FROM '.$table_name.'
						WHERE PortalUserId = '.(int)$user_id;
				$old_groups = $this->Conn->GetCol($sql);

				$new_groups = array_diff($new_groups, $old_groups);

				if ($new_groups) {
					foreach ($new_groups as $new_group) {
						$fields_hash = Array (
							'GroupId'		=>	$new_group,
							'PortalUserId'	=>	$user_id,
						);
						$this->Conn->doInsert($fields_hash, $table_name);
					}
				}
			}
			elseif ($event->Prefix == 'g-ug') {
				$new_users = $this->Application->GetVar('u');

				if (!$new_users) {
					return ;
				}

				$new_users = array_keys($new_users);

				// don't insert duplicate group membership record
				$group_id = $this->Application->GetVar('g_id');
				$table_name = $this->Application->GetTempName(TABLE_PREFIX.'UserGroupRelations', 'prefix:g');

				$sql = 'SELECT PortalUserId
						FROM ' . $table_name . '
						WHERE GroupId = ' . (int)$group_id;
				$old_users = $this->Conn->GetCol($sql);

				$new_users = array_diff($new_users, $old_users);

				if ($new_users) {
					foreach ($new_users as $new_user) {
						$fields_hash = Array (
							'GroupId'		=>	$group_id,
							'PortalUserId'	=>	$new_user,
						);
						$this->Conn->doInsert($fields_hash, $table_name);
					}
				}
			}

			$this->Application->StoreVar($this->Application->GetTopmostPrefix($event->Prefix).'_modified', '1', true); // true for optional
			$event->SetRedirectParam('opener', 'u');
		}

		/**
		 * Sets primary group for user (in editing only)
		 *
		 * @param kEvent $event
		 */
		function OnSetPrimary(&$event)
		{
			$ids = $this->StoreSelectedIDs($event);

			if ($ids) {
				$user =& $this->Application->recallObject('u');
				/* @var $user kDBItem */

				$user->SetDBField('PrimaryGroupId', array_shift($ids));
				$user->Update();
			}

			$this->clearSelectedIDs($event);
		}

		/**
		 * Don't allow primary group record deleting
		 *
		 * @param kEvent $event
		 * @param string $type
		 * @return void
		 * @access protected
		 */
		protected function customProcessing(kEvent &$event, $type)
		{
			if ( $event->Name == 'OnMassDelete' && $type == 'before' ) {
				$ids = $event->getEventParam('ids');

				if ( $ids ) {
					$object =& $event->getObject(Array ('skip_autoload' => true));

					if ( $event->Prefix == 'u-ug' ) {
						// allow deleting non-primary group of current user ($ids - groups)
						$sql = 'SELECT PrimaryGroupId
								FROM ' . $this->Application->GetTempName(TABLE_PREFIX . 'Users', 'prefix:u') . '
								WHERE PortalUserId = ' . (int)$this->Application->GetVar('u_id');
						$primary_group_id = (int)$this->Conn->GetOne($sql);

						$index = array_search($primary_group_id, $ids);

						if ( $index !== false ) {
							unset($ids[$index]);
							$event->setEventParam('ids', $ids);
						}
					}
					elseif ( $event->Prefix == 'g-ug' ) {
						// allow deleting users from group record, then it's not their primary group ($ids - users)
						$group_id = (int)$this->Application->GetVar('g_id');

						$sql = 'SELECT PortalUserId
								FROM ' . TABLE_PREFIX . 'Users
								WHERE PortalUserId IN (' . implode(',', $ids) . ') AND PrimaryGroupId = ' . $group_id;
						$exclude_users = $this->Conn->GetCol($sql);

						$event->setEventParam('ids', array_diff($ids, $exclude_users));
					}
				}
			}
		}
	}