<?php
	$heading_tpl = '
		<tr class="subsectiontitle">
			<td class="text" colspan="2" style="border-top: 1px solid #000000; border-bottom: 1px solid #000000;">%s</td>
		</tr>';

	$error_tpl = '
		<tr class="table-color2">
			<td class="text">%s</td>
		  	<td align="center" width="30">%s</td>
		</tr>';

	$check_titles = Array (
		'php_version' => 'PHP version: 5.2+ (required)',
		'url_rewriting' => 'URL Rewriting Support (optional)',
		'java' => 'Java (optional)',
		'sep1' => '<strong>PHP extensions:</strong>',
		'memcache' => '- Memcache (optional)',
		'curl' => '- Curl (required)',
		'freetype' => '- Freetype (required)',
		'gd_version' => '- GD 1.8+ (required)',
		'jpeg' => '- jpeg (required)',
		'mysql' => '- MySQL (required)',
		'json' => '- JSON (optional)',
		'sep2' => '<strong>PHP settings:</strong>',
		'memory_limit' => "- ini_set('memory_limit', ...) works (optional)",
		'date.timezone' => "- ini_get('date.timezone') - timezone set (required)",
		'variables_order' => "- ini_get('variables_order') - contains \"GPC\" string",
		'output_buffering' => "- ini_get('output_buffering') > 0 - buffering works (required)",
	);

	$output = sprintf($heading_tpl, '<strong>Server-side requirements</strong>');
	$check_results = $this->toolkit->CallPrerequisitesMethod('core/', 'CheckSystemRequirements');

	/*$required_checks = Array (
		'php_version', 'curl', 'freetype', 'gd_version',
		'jpeg', 'mysql', 'date.timezone', 'output_buffering',
	);

	$required_checks = array_diff($required_checks, array_keys( array_filter($check_results) ));*/

	foreach ($check_titles AS $key => $title) {
		if ( substr($key, 0, 3) == 'sep' ) {
			$check_result = '';
		}
		else {
			$check_result = $check_results[$key] ? '[<span style="color:green;">PASSED</span>]' : '[<span class="error">FAILED</span>]';
		}

		$output .= sprintf($error_tpl, $title, $check_result);
	}

	$output .= sprintf($heading_tpl, '<strong>Client-side requirements</strong>', 'text');
	$output .= sprintf($error_tpl, 'Cookies enabled', '[<span class="error" id="cookies_enabled_mark">FAILED</span>]');
	$output .= sprintf($error_tpl, 'JavaScript enabled', '[<span class="error" id="js_enabled_mark">FAILED</span>]');

	$output .= '<input type="hidden" name="js_enabled" id="js_enabled" value="0"/>';
	$output .= '<input type="hidden" name="cookies_enabled" id="cookies_enabled" value="0"/>';

	$output .= "<script type='text/javascript'>
					\$('#js_enabled').val(1);
					\$('#js_enabled_mark').removeClass('error').css('color', 'green').html('PASSED');

					document.cookie = 'install_cookie_test=1';
					var \$cookies_enabled = document.cookie.indexOf('install_cookie_test') != -1;

					if ( \$cookies_enabled ) {
						\$('#cookies_enabled').val(1);
						\$('#cookies_enabled_mark').removeClass('error').css('color', 'green').html('PASSED');
					}
				</script>";

	echo $output;
?>
