<?php
/**
* @version	$Id$
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2011 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class SpamReportTagProcessor extends kDBTagProcessor {

	/**
	 * Returns a link for editing ad/user
	 *
	 * @param Array $params
	 * @return string
	 */
	function ItemEditLink($params)
	{
		$object =& $this->getObject();
		/* @var $object kDBList */

		$prefix = $object->GetDBField('ItemPrefix');

		$url_params = Array (
			'm_opener'			=>	'd',
			$prefix.'_mode'		=>	't',
			$prefix.'_event'	=>	'OnEdit',
			$prefix.'_id'		=>	$object->GetDBField('ItemId'),
			'pass'				=>	'all,'.$prefix,
		);

		if ( $this->IsReviewReport($params) ) {
			$edit_template = 'reviews/review_direct_edit';
			$url_params['pass_through'] = 'item_prefix';
			$url_params['item_prefix'] = $prefix;
		}
		else {
			$edit_template = '';
		}

		return $this->Application->HREF($edit_template,'', $url_params);
	}

	/**
	 * Builds a link, to delete item, associated with this spam report
	 *
	 * @param Array $params
	 * @return string
	 */
	function AssocItemDeleteLink($params)
	{
		$object =& $this->getObject();
		/* @var $object kDBList */

		$prefix = $this->getPrefixSpecial();

		$url_params = Array (
			$prefix . '_event'	=>	'OnDeleteAssocItem',
			$prefix . '_id'		=>	$object->GetID(),
			'pass'				=>	'm,'.$prefix,
		);

		return $this->Application->HREF('','', $url_params);
	}

	/**
	 * Checks, that it's review report
	 *
	 * @param Array $params
	 * @return string
	 * @access protected
	 */
	protected function IsReviewReport($params)
	{
		$object =& $this->getObject($params);
		/* @var $object kDBItem */

		return preg_match('/rev$/',  $object->GetDBField('ItemPrefix'));
	}
}