<?php
/**
* @version	$Id: promo_block_tp.php 14929 2011-12-28 14:01:17Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2011 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class PromoBlockTagProcessor extends kDBtagProcessor {

	/**
	 * Returns link that registers promotion click and redirect user to the page, associated with the promotion
	 *
	 * @param Array $params
	 * @return string
	 * @access protected
	 */
	protected function PromoLink($params)
	{
		$object =& $this->getObject($params);
		/* @var $object kDBItem */

		$url_params = Array (
			$this->Prefix . '_event' => 'OnFollowLink',
			'pass' => 'm,' . $this->Prefix,
			'__NO_REWRITE__' => 1,
		);

		return $this->Application->HREF('index', '', $url_params);
	}

	/**
	 * Checks, that link should be opened in new window
	 *
	 * @param Array $params
	 * @return bool
	 * @access protected
	 */
	protected function LinkInNewWindow($params)
	{
		$object =& $this->getObject($params);
		/* @var $object kDBItem */

		if ( $object->GetDBField('LinkType') == 1 ) { // Internal
			return false;
		}

		return $object->GetDBField('OpenInNewWindow');
	}

	/**
	 * Get value from corresponding PromoGroupBlocks record
	 *
	 * @param Array $params
	 * @return bool
	 * @access protected
	 */
	protected function GetGroupSetting(Array $params)
	{
		static $group_data = null;

		if ( !isset($group_data) ) {
			if ( isset($params['group_id']) && $params['group_id'] ) {
				$group_id = $params['group_id'];
			}
			else {
				$page =& $this->Application->recallObject('st');
				/* @var $page CategoriesItem */

				$group_id = $page->GetDBField('PromoBlockGroupId');
			}

			$sql = 'SELECT *
					FROM ' . TABLE_PREFIX . 'PromoBlockGroups
					WHERE PromoBlockGroupId = ' . (int)$group_id;
			$group_data = $this->Conn->GetRow($sql);
		}

		$setting_name = $params['name'];

		return isset($group_data[$setting_name]) ? $group_data[$setting_name] : '';
	}
}
