<?php
/**
* @version	$Id: inp_session.php 14714 2011-11-01 10:05:18Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class InpSession extends Session
{
	/**
	 * Enter description here...
	 *
	 * @var InpSessionStorage
	 * @access protected
	 */
	protected $Storage;

	public function Init($prefix, $special)
	{
		$this->SessionTimeout = $this->Application->ConfigValue('SessionTimeout');

		$path = (BASE_PATH == '') ? '/' : BASE_PATH;
		$this->SetCookiePath($path);

		$cookie_name = $this->Application->ConfigValue('SessionCookieName');

		if ( !$cookie_name ) {
			$cookie_name = 'sid';
		}

		$admin_session = ($this->Application->isAdmin && $special !== 'front') || ($special == 'admin');

		if ( $admin_session ) {
			$cookie_name = 'adm_' . $cookie_name;
		}

		$this->SetCookieName($cookie_name);
		$this->SetCookieDomain(SERVER_NAME);

		if ( $admin_session ) {
			$mode = self::smAUTO;
		}
		elseif ( defined('IS_INSTALL') && IS_INSTALL ) {
			$mode = self::smCOOKIES_ONLY;
		}
		else {
			$ses_mode = $this->Application->ConfigValue('CookieSessions');

			if ( $ses_mode == 2 ) {
				$mode = self::smAUTO;
			}
			elseif ( $ses_mode == 1 ) {
				$mode = self::smCOOKIES_ONLY;
			}
			elseif ( $ses_mode == 0 ) {
				$mode = self::smGET_ONLY;
			}
			else {
				$mode = self::smAUTO;
			}
		}

		$this->SetMode($mode);

		parent::Init($prefix, $special);
	}

	function Destroy()
	{
		$this->Storage->DeleteSession();
		$this->Storage->DeleteEditTables();
		$this->Data = new Params();
		$this->SID = $this->CachedSID = '';

		if ($this->CookiesEnabled) {
			$this->SetSessionCookie(); //will remove the cookie due to value (sid) is empty
		}

		$this->SetSession(); //will create a new session
	}

}

