<?php
/**
* @version	$Id: prerequisites.php 14863 2011-12-13 10:01:17Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	$prerequisite_class = 'InPortalPrerequisites';

	/**
	 * Class, that holds all prerequisite scripts for "In-Portal" module
	 *
	 */
	class InPortalPrerequisites {

		/**
		 * Install toolkit instance
		 *
		 * @var kInstallToolkit
		 */
		var $_toolkit = null;

		/**
		* Connection to database
		*
		* @var kDBConnection
		* @access protected
		*/
		protected $Conn = null;

		/**
		 * Sets common instance of installator toolkit
		 *
		 * @param kInstallToolkit $instance
		 */
		function setToolkit(&$instance)
		{
			$this->_toolkit =& $instance;
		}

		/**
		 * Checks minimal version, that could be upgradeable
		 *
		 * @return kDBConnection
		 */
		function &getConnection()
		{
			return $this->_toolkit->Conn;
		}

		/**
		 * Checks minimal version, that could be upgradeable
		 *
		 * @param Array $versions
		 * @param string $mode when called mode {install, upgrade, standalone)
		 * @return Array
		 */
		function CheckPrerequisites($versions, $mode)
		{
			$errors = Array ();

			if ($mode == 'upgrade') {
				$sql = 'SELECT Version
						FROM ' . TABLE_PREFIX . 'Modules
						WHERE Name = "In-Portal"';

				$conn =& $this->getConnection();
				$inportal_version = $conn->GetOne($sql);

				if ($inportal_version === false) {
					// only, when In-Portal was installed
					return $errors;
				}

				$min_version = '4.3.1';

				$current_version = $this->_toolkit->ConvertModuleVersion($inportal_version);
				$needed_version = $this->_toolkit->ConvertModuleVersion($min_version);
				if ($current_version < $needed_version) {
					$errors[] = 'Please upgrade "In-Portal" to version ' . $min_version;
				}
			}

			return $errors;
		}

		/**
		 * Returns information about system requirements
		 *
		 * @return array
		 */
		function CheckSystemRequirements()
		{
			$ret = Array ();
			$ret['php_version'] = version_compare(PHP_VERSION, '5.2.0', '>=');

			$ret['url_rewriting'] = function_exists('apache_get_modules') && in_array('mod_rewrite', apache_get_modules());
			$ret['memcache'] = class_exists('Memcache');
			$ret['curl'] = function_exists('curl_init');
			$ret['freetype'] = function_exists('imagettfbbox');

			$ret['gd_version'] = $ret['jpeg'] = false;

			if ( function_exists('gd_info') ) {
				$gd_info = gd_info();

				$gd_version = preg_replace('/[^\d.]/', '', $gd_info['GD Version']);
				$ret['gd_version'] = version_compare($gd_version, '1.8', '>=');

				$ret['jpeg'] = isset($gd_info['JPEG Support']) && $gd_info['JPEG Support'];
			}

			$ret['mysql'] = function_exists('mysql_connect');
			$ret['json'] = function_exists('json_encode');

			$output = shell_exec('java -version 2>&1');
			$ret['java'] = stripos($output, 'java version') !== false;

			$ret['memory_limit'] = $this->isPhpSettingChangeable('memory_limit', '33M');
			$ret['date.timezone'] = ini_get('date.timezone') != '';

			$ret['variables_order'] = strpos(ini_get('variables_order'), 'GPC') !== false;
			$ret['output_buffering'] = ini_get('output_buffering') > 0;

			return $ret;
		}

		/**
		 * Detects if setting of php.ini can be changed
		 *
		 * @param string $setting_name
		 * @param string $new_value
		 * @return bool
		 */
		protected function isPhpSettingChangeable($setting_name, $new_value)
		{
			$backup_value = ini_get($setting_name);
			ini_set($setting_name, $new_value);

			if ( ini_get($setting_name) != $backup_value ) {
				ini_set($setting_name, $backup_value);

				return true;
			}

			return false;
		}

		/**
		 * Returns information about DB requirements
		 *
		 * @return array
		 */
		function CheckDBRequirements()
		{
			// check PHP version 5.2+
			$ret = Array();

			$sql = 'SELECT VERSION()';
			$conn =& $this->getConnection();

			$db_version = preg_replace('/[^\d.]/', '', $conn->GetOne($sql));
			$ret['version'] = version_compare($db_version, '5.0', '>=');

			$sql = 'SHOW VARIABLES LIKE "max_allowed_packet"';
			$db_variables = $conn->Query($sql, 'Variable_name');

			$ret['packet_size'] = $db_variables['max_allowed_packet']['Value'] >= 1048576;

			return $ret;
		}
	}