<?php
/**
* @version	$Id: session_log_eh.php 15065 2012-01-17 15:11:29Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class SessionLogEventHandler extends kDBEventHandler {

		/**
		 * Opens log for new session
		 *
		 * @param kEvent $event
		 */
		function OnStartSession(&$event)
		{
			if (!$this->Application->ConfigValue('UseChangeLog')) {
				// don't use session log when change log is disabled
				return ;
			}

			$object =& $this->Application->recallObject($event->Prefix, null, Array ('skip_autoload' => 1));
			/* @var $object kDBItem */

			$fields_hash = Array (
				'SessionStart' => adodb_mktime(),
				'IP' => $_SERVER['REMOTE_ADDR'],
				'PortalUserId' => $this->Application->RecallVar('user_id'),
				'SessionId' => $this->Application->GetSID(),
				'Status' => SESSION_LOG_ACTIVE,
			);

			$object->SetDBFieldsFromHash($fields_hash);

			$object->UpdateFormattersSubFields();

			if ($object->Create()) {
				$this->Application->StoreVar('_SessionLogId_', $object->GetID());
			}
		}

		/**
		 * Closes log for current session
		 *
		 * @param kEvent $event
		 */
		function OnEndSession(&$event)
		{
			$object =& $this->Application->recallObject($event->Prefix, null, Array ('skip_autoload' => 1));
			/* @var $object kDBItem */

			$object->Load($this->Application->RecallVar('_SessionLogId_'));
			if (!$object->isLoaded()) {
				return ;
			}

			$fields_hash = Array (
				'SessionEnd' => adodb_mktime(),
				'Status' => SESSION_LOG_LOGGED_OUT,
			);

			$object->SetDBFieldsFromHash($fields_hash);

			$object->UpdateFormattersSubFields();
			$object->Update();
		}

		/**
		 * Apply custom processing to item
		 *
		 * @param kEvent $event
		 * @param string $type
		 * @return void
		 * @access protected
		 */
		protected function customProcessing(kEvent &$event, $type)
		{
			if ( $event->Name == 'OnMassDelete' && $type == 'before' ) {
				$ids = $event->getEventParam('ids');
				if ( $ids ) {
					$id_field = $this->Application->getUnitOption($event->Prefix, 'IDField');
					$table_name = $this->Application->getUnitOption($event->Prefix, 'TableName');

					$sql = 'SELECT ' . $id_field . '
							FROM ' . $table_name . '
							WHERE ' . $id_field . ' IN (' . implode(',', $ids) . ') AND Status <> ' . SESSION_LOG_ACTIVE;
					$allowed_ids = $this->Conn->GetCol($sql);

					$event->setEventParam('ids', $allowed_ids);
				}
			}
		}

		/**
		 * Delete changes, related to deleted session
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnAfterItemDelete(kEvent &$event)
		{
			parent::OnAfterItemDelete($event);

			$object =& $event->getObject();
			/* @var $object kDBItem */

			$sql = 'SELECT ' . $this->Application->getUnitOption('change-log', 'IDField') . '
					FROM ' . $this->Application->getUnitOption('change-log', 'TableName') . '
					WHERE SessionLogId = ' . $object->GetID();
			$related_ids = $this->Conn->GetCol($sql);

			if ( $related_ids ) {
				$temp_handler =& $this->Application->recallObject('change-log_TempHandler', 'kTempTablesHandler');
				/* @var $temp_handler kTempTablesHandler */

				$temp_handler->DeleteItems('change-log', '', $related_ids);
			}
		}

	}