<?php
/**
* @version	$Id: content_eh.php 15051 2012-01-16 16:46:07Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class ContentEventHandler extends kDBEventHandler {

		/**
		 * Checks user permission to execute given $event
		 *
		 * @param kEvent $event
		 * @return bool
		 * @access public
		 */
		public function CheckPermission(kEvent &$event)
		{
			$perm_helper =& $this->Application->recallObject('PermissionsHelper');
			/* @var $perm_helper kPermissionsHelper */

			$user_id = $this->Application->RecallVar('user_id');

			// user can change top category
			$top_category = $this->Application->getBaseCategory();
			$perm_status = $perm_helper->CheckUserPermission($user_id, 'CATEGORY.MODIFY', 0, $top_category);

			return $perm_helper->finalizePermissionCheck($event, $perm_status);
		}

		/**
		 * Saves changes to a content block (+ creates draft if missing)
		 *
		 * @param kEvent $event
		 */
		function OnSaveContentBlock(&$event)
		{
			if ($this->Application->CheckPermission('SYSTEM_ACCESS.READONLY', 1)) {
				$event->status = kEvent::erFAIL;
				return ;
			}

			if ( !$this->saveContentBlock($event, false) ) {
				$event->status = kEvent::erFAIL;
			}

			$event->SetRedirectParam('opener', 'u');
		}

		/**
		 * Performs auto-save of current content block (will create draft too)
		 *
		 * @param kEvent $event
		 */
		function OnAutoSave(&$event)
		{
			$event->status = kEvent::erSTOP;

			if ( $this->Application->GetVar('ajax') != 'yes' ) {
				return ;
			}

			echo $this->saveContentBlock($event, true);
		}

		/**
		 * Saves content block
		 *
		 * @param kEvent $event
		 * @param bool $is_draft
		 * @return string
		 */
		function saveContentBlock(&$event, $is_draft)
		{
			$object =& $event->getObject( Array('skip_autoload' => true) );
			/* @var $object kDBItem */

			$items_info = $this->Application->GetVar( $event->getPrefixSpecial(true) );
			if ( !$items_info ) {
				return '';
			}

			list ($object, $revision) = $this->getContentBlockAndRevision($event);
			/* @var $revision kDBItem */

			list (, $field_values) = each($items_info);
			$object->SetFieldsFromHash($field_values, $this->getRequestProtectedFields($field_values));
			$updated = $object->Update();

			if ( $updated ) {
				$revision->SetDBField('AutoSavedOn_date', adodb_mktime());
	 			$revision->SetDBField('AutoSavedOn_time', adodb_mktime());
	 			$revision->Update();
			}

			if ( $is_draft ) {
				if ( $updated ) {
		 			$page_helper =& $this->Application->recallObject('PageHelper');
		 			/* @var $page_helper PageHelper */

		 			return $revision->GetField('AutoSavedOn') . ' (' . $page_helper->getAgoTime( $revision->GetDBField('AutoSavedOn') ) . ')';
		 		}
			}
			else {
				return $updated;
			}

			return '';
		}

		/**
		 * Returns last autosave time
		 *
		 * @param kEvent $event
		 */
		function OnGetAutoSaveTime(&$event)
		{
			$event->status = kEvent::erSTOP;

			if ( $this->Application->GetVar('ajax') != 'yes' ) {
				return ;
			}

			list ($object, $revision) = $this->getContentBlockAndRevision($event);
			/* @var $revision kDBItem */

			$page_helper =& $this->Application->recallObject('PageHelper');
 			/* @var $page_helper PageHelper */

 			$time = $revision->GetField('AutoSavedOn');

 			if ( $time ) {
 				echo $time . ' (' . $page_helper->getAgoTime( $revision->GetDBField('AutoSavedOn') ) . ')';
 			}
		}

		/**
		 * Loads content block from given revision
		 *
		 * @param kDBItem $object
		 * @param kDBItem $revision
		 */
		function loadFromRevision(&$object, &$revision)
		{
			$load_keys = Array (
				'PageId' => $object->GetDBField('PageId'),
				'ContentNum' => $object->GetDBField('ContentNum'),
				'RevisionId' => $revision->GetID(),
			);

			$object->Load($load_keys);
		}

		function getContentBlockAndRevision(&$event)
		{
			$object =& $event->getObject( Array('skip_autoload' => true) );
			/* @var $object kDBItem */

			$items_info = $this->Application->GetVar( $event->getPrefixSpecial(true) );
			if ( !$items_info ) {
				return ;
			}

			list ($id, $field_values) = each($items_info);
			$object->Load($id);

			$revision =& $this->Application->recallObject('page-revision', null, Array ('skip_autoload' => true));
			/* @var $revision kDBItem */

			$revision->Load( $object->GetDBField('RevisionId') );

			if ( $this->Application->ConfigValue('EnablePageContentRevisionControl') && !$revision->GetDBField('IsDraft') ) {
				// editing live revision of a page's content block -> get draft for current user and page
				$load_keys = Array (
					'PageId' => $revision->GetDBField('PageId'),
					'IsDraft' => 1,
					'CreatedById' => $this->Application->RecallVar('user_id'),
				);

				$revision->Load($load_keys);

				if ( $revision->isLoaded() ) {
					// draft found -> use draft's content block version
					$this->loadFromRevision($object, $revision);
				}
				else {
					// draft not found -> create new
					$revision->SetDBFieldsFromHash($load_keys);
					$revision->SetDBField('FromRevisionId', $object->GetDBField('RevisionId'));

					if ( $revision->Create() ) {
						$this->loadFromRevision($object, $revision);
					}
				}
			}

			return Array (&$object, &$revision);
		}
	}