<?php
/**
* @version	$Id$
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2011 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class PermissionTypeEventHandler extends kDBEventHandler {

	/**
	 * Cant delete system permissions
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnBeforeItemDelete(kEvent &$event)
	{
		parent::OnBeforeItemDelete($event);

		$object =& $event->getObject();
		/* @var $object kDBItem */

		if ( $object->GetDBField('IsSystem') ) {
			// prevents deletion of this permission
			$event->status = kEvent::erFAIL;

			// informs main event, that redirect shouldn't be made
			$event->MasterEvent->status = kEvent::erFAIL;
			$this->Application->SetVar('cant_delete_system_permission', 1);
		}
	}
}
