<?php
/**
* @version	$Id: customfield_formatter.php 14748 2011-11-09 09:35:48Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2011 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

/**
 * Like kMultiLanguage formatter for LEFT JOINed custom fields
 *
 */
class kCustomFieldFormatter extends kFormatter
{

	/**
	 * Formats value of a given field
	 *
	 * @param string $value
	 * @param string $field_name
	 * @param kDBItem|kDBList $object
	 * @param string $format
	 * @return string
	 */
	function Format($value, $field_name, &$object, $format=null)
	{
		$options = $object->GetFieldOptions($field_name);

		$master_field = isset($options['master_field']) ? $options['master_field'] : false;
		if (!$master_field) {
			return $value;
		}

		$format = isset($format) ? $format : ( isset($options['format']) ? $options['format'] : null);

		if ($value == '' && $format != 'no_default') { // try to get default language value
			$def_lang_value = $object->GetDBField($master_field);
			if ($def_lang_value == '') return NULL;
			return $def_lang_value; //return value from default language
		}

		return $value;
	}

}