<?php
/**
* @version	$Id: users_syncronize.php 14241 2011-03-16 20:24:35Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class UsersSyncronizeManager extends kBase {

		/**
		 * Class to skip during syncronization
		 *
		 * @var string
		 */
		var $skipClass = '';

		var $syncClasses = Array();

		/**
		 * Initializes user syncronization manager
		 *
		 * @param string $skip_class script that recalls this object passes own syncronization class here
		 * @return UsersSyncronizeManager
		 */
		function UsersSyncronizeManager($skip_class)
		{
			parent::kBase();

			$this->skipClass = $skip_class;

			$defs_file = SYNC_CLASS_PATH.'/sync_config.php';

			if (file_exists($defs_file))
			{
				include_once $defs_file;
				foreach ($sync_classes as $class_info) {
					$this->addSyncClass($class_info['class_name'], SYNC_CLASS_PATH.'/'.$class_info['class_file'], $class_info['sub_folder']);
				}
			}
		}

		function addSyncClass($class_name, $class_file, $sub_folder)
		{
			$this->syncClasses[$class_name] = Array('file' => $class_file, 'sub_folder' => $sub_folder);
		}

		/**
		 * Performs action specified for all syncronization classes.
		 * You can pass other arguments to function, they will be passed to action handler
		 *
		 * @param string $action
		 */
		function performAction($action)
		{
			$args = func_get_args();
			array_shift($args);

			foreach ($this->syncClasses as $class_name => $class_info) {
				if ($class_name == $this->skipClass) continue;
				$this->Application->registerClass($class_name, $class_info['file']);
				$sync_object =& $this->Application->recallObjectP($class_name, null, Array(), $class_info['sub_folder'], $class_name);
				call_user_func_array( Array(&$sync_object, $action), $args);
			}
		}

		/**
		 * Create new instance of object
		 *
		 * @return kBase
		 */
		function &makeClass($skip_class)
		{
			$sync_manager = new UsersSyncronizeManager($skip_class);
			return $sync_manager;
		}
	}


	/**
	 * Base class for 3rd party site user syncronizations
	 *
	 */
	class UsersSyncronize extends kBase {

		/**
		 * Sub folder to which syncronizable tool is installed
		 *
		 * @var string
		 */
		var $subFolder = '';

		/**
		* Connection to database
		*
		* @var kDBConnection
		* @access public
		*/
		var $Conn;

		function UsersSyncronize($sub_folder)
		{
			parent::kBase();
			$this->subFolder = $sub_folder;
			$this->Conn =& $this->Application->GetADODBConnection();
		}

		/**
		 * Used to login user with given username & password
		 *
		 * @param string $user
		 * @param string $password
		 * @return bool
		 */
		function LoginUser($user, $password)
		{
			return true;
		}

		/**
		 * Used to logout currently logged in user (if any)
		 *
		 */
		function LogoutUser()
		{

		}

		/**
		 * Creates user
		 *
		 * @param Array $user_data
		 * @return bool
		 */
		function createUser($user_data)
		{
			return true;
		}

		/**
		 * Update user info with given $user_id
		 *
		 * @param Array $user_data
		 * @return bool
		 */
		function updateUser($user_data)
		{
			return true;
		}

		/**
		 * Deletes user
		 *
		 * @param Array $user_data
		 * @return bool
		 */
		function deleteUser($user_data)
		{
			return true;
		}

		/**
		 * Create new instance of object
		 *
		 * @return kBase
		 */
		function &makeClass($sub_folder, $class_name)
		{
			return new $class_name($sub_folder);
		}

	}