<?php
/**
* @version	$Id: submission_log_config.php 14537 2011-09-18 14:19:48Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'submission-log',
		'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'SubmissionLogEventHandler', 'file' => 'submission_log_eh.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'SubmissionLogTagProcessor', 'file' => 'submission_log_tp.php', 'build_event' => 'OnBuild'),

		'AutoLoad' => true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'event',
			4 => 'form_id'
		),

		'IDField' => 'SubmissionLogId',

		'TableName' => TABLE_PREFIX . 'SubmissionLog',

		'StatusField' => Array ('ReplyStatus'),

		'ParentPrefix' => 'formsubs',
		'ForeignKey' => 'FormSubmissionId',
		'ParentTableKey' => 'FormSubmissionId',
		'AutoDelete' => true,
		'AutoClone' => true,

		'TitleField' => 'Subject',

		'ListSQLs' => Array (
			'' => '	SELECT %1$s.* %2$s FROM %1$s',
		),

		'ListSortings' => Array (
			'' => Array (
				'Sorting' => Array ('SubmissionLogId' => 'desc'),
			)
		),

		'Fields' => Array (
			'SubmissionLogId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'FormSubmissionId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),

			'FromEmail' => Array (
				'type' => 'string', 'max_len' => 255,
				'regexp' => '/' . REGEX_EMAIL_USER . '@' . REGEX_EMAIL_DOMAIN . '/',
				'not_null' => 1, 'required' => 1, 'default' => ''
			),

			'ToEmail' => Array (
				'type' => 'string', 'max_len' => 255,
				'regexp' => '/' . REGEX_EMAIL_USER . '@' . REGEX_EMAIL_DOMAIN . '/',
				'not_null' => 1, 'required' => 1, 'default' => ''
			),

			'Cc' => Array ('type' => 'string', 'default' => NULL),
    		'Bcc' => Array ('type' => 'string', 'default' => NULL),
			'Subject' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'required' => 1, 'default' => ''),
			'Message' => Array ('type' => 'string', 'required' => 1, 'using_fck' => 1, 'default' => NULL),

			'Attachment' => Array (
				'type' => 'string',
				'formatter' => 'kUploadFormatter', 'upload_dir' => SUBMISSION_LOG_ATTACHMENT_PATH,
            	'file_types' => '*.*', 'files_description' => '!la_hint_AllFiles!', 'multiple' => 100,
				'default' => NULL
			),

			'ReplyStatus' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
				'not_null' => 1, 'default' => 0 // create as not replied
			),

			'SentStatus' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No', 2 => 'la_opt_Bounce'), 'use_phrases' => 1,
				'not_null' => 1, 'default' => 0 // create as not sent
			),

			'SentOn' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => NULL),
    		'RepliedOn' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => NULL),
    		'VerifyCode' => Array ('type' => 'string', 'max_len' => 32, 'not_null' => 1, 'default' => ''),
    		'DraftId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
    		'MessageId' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
			'BounceInfo' => Array ('type' => 'string', 'default' => NULL),
			'BounceDate' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => NULL),
		),

		'VirtualFields' => Array (
			'ReplyTo' => Array ('type' => 'int', 'default' => null),
		),

		'Grids' => Array (
			'Default' => Array (
				'Icons' => Array (0 => 'icon16_not_replied.gif', 1 => 'icon16_replied.gif'),
				'Fields' => Array (
					'SubmissionLogId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', ),
					'Subject' => Array ('data_block' => 'grid_subject_td', 'filter_block' => 'grid_like_filter',),
					'Message' => Array ('filter_block' => 'grid_like_filter', 'first_chars' => 100),
					'ReplyStatus' => Array ('filter_block' => 'grid_options_filter',),
					'SentStatus' => Array ('filter_block' => 'grid_options_filter',),
					'FromEmail' => Array ('filter_block' => 'grid_like_filter',),
					'ToEmail' => Array ('filter_block' => 'grid_like_filter',),
					'SentOn' => Array ('filter_block' => 'grid_date_range_filter',),
					'RepliedOn' => Array ('filter_block' => 'grid_date_range_filter',),
					'Cc' => Array ('filter_block' => 'grid_like_filter', 'hidden' => 1),
					'Bcc' => Array ('filter_block' => 'grid_like_filter', 'hidden' => 1),
					'BounceInfo' => Array ('filter_block' => 'grid_like_filter', 'hidden' => 1),
					'BounceDate' => Array ('filter_block' => 'grid_date_range_filter', 'hidden' => 1),
				),
			),
		),
	);