<?php
/**
* @version	$Id: multilang_formatter.php 14537 2011-09-18 14:19:48Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

class kMultiLanguage extends kFormatter
{

	/**
	 * Multilanguage helper
	 *
	 * @var kMultiLanguageHelper
	 */
	var $helper = null;

	function kMultiLanguage()
	{
		parent::kFormatter();

		$this->helper =& $this->Application->recallObject('kMultiLanguageHelper');
	}

	/**
	 * Returns ML field equivalent to field name specifed
	 *
	 * @param string $field_name
	 * @param bool $from_primary use primary/current language for name custruction
	 * @return string
	 */
	function LangFieldName($field_name, $from_primary = false)
	{
		static $primary_language = null;

		if (preg_match('/^l[0-9]+_/', $field_name)) {
			return $field_name;
		}

		if (!isset($primary_language)) {
			$primary_language = $this->Application->GetDefaultLanguageId();
		}

		$lang = $from_primary ? $primary_language : $this->Application->GetVar('m_lang');

		if (!$lang || ($lang == 'default')) {
			$lang = $primary_language;
		}

		return 'l' . $lang . '_' . $field_name;
	}

	/**
	 * The method is supposed to alter config options or cofigure object in some way based on its usage of formatters
	 * The methods is called for every field with formatter defined when configuring item.
	 * Could be used for adding additional VirtualFields to an object required by some special Formatter
	 *
	 * @param string $field_name
	 * @param array $field_options
	 * @param kDBBase $object
	 */
	function PrepareOptions($field_name, &$field_options, &$object)
	{
		if (getArrayValue($field_options, 'master_field') || getArrayValue($field_options, 'options_processed')) {
			return ;
		}

		$lang_field_name = $this->LangFieldName($field_name);

		//substitude title field
		$title_field = $this->Application->getUnitOption($object->Prefix, 'TitleField');
		if ($title_field == $field_name) {
			$this->Application->setUnitOption($object->Prefix, 'TitleField', $lang_field_name);
		}

		$primary_language_id = $this->Application->GetDefaultLanguageId();
		$fields = $this->Application->getUnitOption($object->Prefix, 'Fields', Array ());
		$virtual_fields = $this->Application->getUnitOption($object->Prefix, 'VirtualFields', Array ());

		// substitude real field
		if (array_key_exists($field_name, $fields)) {
			$tmp_field_options = $fields[$field_name];
			$tmp_field_options['master_field'] = $field_name;
			$tmp_field_options['error_field'] = $field_name;
			$field_required = array_key_exists('required', $tmp_field_options) && $tmp_field_options['required'];

			for ($language_id = 1; $language_id <= $this->helper->languageCount; $language_id++) {
				if (!$this->helper->LanguageFound($language_id)) {
					continue;
				}

				// make all non-primary language fields not required
				if ($language_id != $primary_language_id) {
					unset($tmp_field_options['required']);
				}
				elseif ($field_required) {
					$tmp_field_options['required'] = $field_required;
				}

				$translated_field = 'l' . $language_id . '_' . $field_name;
				$fields[$translated_field] = $tmp_field_options;
				$object->Fields[$translated_field] = $tmp_field_options;
			}

			// makes original field non-required
			unset($fields[$field_name]['required'], $object->Fields[$field_name]['required']);

			// prevents real field with formatter set to be saved in db
			$virtual_fields[$field_name] = $object->Fields[$field_name];
			$object->VirtualFields[$field_name] = $object->Fields[$field_name];
		}
		elseif (array_key_exists($field_name, $virtual_fields)) {
			// substitude virtual field
			$calculated_fields = $this->Application->getUnitOption($object->Prefix, 'CalculatedFields');
			$calculated_field_special = array_key_exists($object->Special, $calculated_fields) ? $object->Special : (array_key_exists('', $calculated_fields) ? '' : false);

			$tmp_field_options = $virtual_fields[$field_name];
			$tmp_field_options['master_field'] = $field_name;
			$tmp_field_options['error_field'] = $field_name;
			$field_required = array_key_exists('required', $tmp_field_options) && $tmp_field_options['required'];

			for ($language_id = 1; $language_id <= $this->helper->languageCount; $language_id++) {
				if (!$this->helper->LanguageFound($language_id)) {
					continue;
				}

				// make all non-primary language fields not required
				if ($language_id != $primary_language_id) {
					unset($tmp_field_options['required']);
				}
				elseif ($field_required) {
					$tmp_field_options['required'] = $field_required;
				}

				$translated_field = 'l' . $language_id . '_' . $field_name;
				$virtual_fields[$translated_field] = $tmp_field_options;
				$object->VirtualFields[$translated_field] = $tmp_field_options;

				// substitude calculated fields associated with given virtual field
				foreach ($calculated_fields as $special => $special_fields) {
					if (!array_key_exists($field_name, $special_fields)) {
						continue;
					}

					$calculated_fields[$special][$translated_field] = str_replace('%2$s', $language_id, $special_fields[$field_name]);

					if ($special === $calculated_field_special) {
						$object->CalculatedFields[$translated_field] = $calculated_fields[$special][$translated_field];
					}
				}

				// manually copy virtual field back to fields (see kDBBase::setVirtualFields about that)
				$fields[$translated_field] = $tmp_field_options;
				$object->Fields[$translated_field] = $tmp_field_options;
			}

			// remove original calculated field
			foreach ($calculated_fields as $special => $special_fields) {
				unset($calculated_fields[$special][$field_name]);
			}

			unset($object->CalculatedFields[$field_name]);

			// save back calculated fields
			$this->Application->setUnitOption($object->Prefix, 'CalculatedFields', $calculated_fields);

			// makes original field non-required
			unset($fields[$field_name]['required'], $object->Fields[$field_name]['required']);
			unset($virtual_fields[$field_name]['required'], $object->VirtualFields[$field_name]['required']);
		}

		//substitude grid fields
		$grids = $this->Application->getUnitOption($object->Prefix, 'Grids', Array());
		foreach ($grids as $name => $grid) {
			if ( getArrayValue($grid, 'Fields', $field_name) ) {
				// used by column picker to track column position
				$grids[$name]['Fields'][$field_name]['formatter_renamed'] = true;

				if (!array_key_exists('format', $grids[$name]['Fields'][$field_name])) {
					// prevent displaying value from primary language
					// instead of missing value in current language
					$grids[$name]['Fields'][$field_name]['format'] = 'no_default';
				}

				if ( !isset($grid['Fields'][$field_name]['title']) ) {
					$grids[$name]['Fields'][$field_name]['title'] = 'column:la_fld_' . $field_name;
				}

				array_rename_key($grids[$name]['Fields'], $field_name, $lang_field_name);
			}

			// update sort fields - used for sorting and filtering in SQLs
			foreach ($grid['Fields'] as $grid_fld_name => $fld_options) {
				if (isset($fld_options['sort_field']) && $fld_options['sort_field'] == $field_name) {
					$grids[$name]['Fields'][$grid_fld_name]['sort_field'] = $lang_field_name;
				}
			}
		}
		$this->Application->setUnitOption($object->Prefix, 'Grids', $grids);

		//substitude default sortings
		$sortings = $this->Application->getUnitOption($object->Prefix, 'ListSortings', Array());
		foreach ($sortings as $special => $the_sortings) {
			if (isset($the_sortings['ForcedSorting'])) {
				array_rename_key($sortings[$special]['ForcedSorting'], $field_name, $lang_field_name);
			}
			if (isset($the_sortings['Sorting'])) {
				array_rename_key($sortings[$special]['Sorting'], $field_name, $lang_field_name);
			}
		}
		$this->Application->setUnitOption($object->Prefix, 'ListSortings', $sortings);

		//TODO: substitude possible language-fields sortings after changing language
		$fields[$field_name]['options_processed'] = $field_options['options_processed'] = true;
		$this->Application->setUnitOption($object->Prefix, 'Fields', $fields);
		$this->Application->setUnitOption($object->Prefix, 'VirtualFields', $virtual_fields);
	}

	/*function UpdateSubFields($field, $value, &$options, &$object)
	{

	}
	*/

	/**
	 * Checks, that field value on primary language is set
	 *
	 * @param string $field
	 * @param mixed $value
	 * @param Array $options
	 * @param kDBItem $object
	 */
	function UpdateMasterFields($field, $value, &$options, &$object)
	{
		$master_field = array_key_exists('master_field', $options) ? $options['master_field'] : false;
		if (!$master_field) {
			return ;
		}

		// moved here from Parse, because at Parse time not all of the fields may be set - this is extremly actual, when working with PopulateMlFields mode
		$lang = $this->Application->GetVar('m_lang');
		$def_lang = $this->Application->GetDefaultLanguageId();

		if (!$this->Application->GetVar('allow_translation') && ($lang != $def_lang) && getArrayValue($options, 'required')) {
			$def_lang_field = 'l' . $def_lang . '_' . $master_field;
			if ( !$object->ValidateRequired($def_lang_field, $options) ) {
				$object->SetError($master_field, 'primary_lang_required');

				if (array_key_exists($def_lang_field, $object->Fields)) {
					$object->SetError($def_lang_field, 'primary_lang_required');
				}
			}
		}
	}

	function Format($value, $field_name, &$object, $format=null)
	{
		$master_field = isset($object->Fields[$field_name]['master_field']) ? $object->Fields[$field_name]['master_field'] : false;
		if (!$master_field) { // if THIS field is master it does NOT have reference to it's master_field
			$lang = $this->Application->GetVar('m_lang');
			$value = $object->GetDBField('l'.$lang.'_'.$field_name); //getting value of current language
			$master_field = $field_name; // THIS is master_field
		}
		$options = $object->GetFieldOptions($field_name);
		$format = isset($format) ? $format : ( isset($options['format']) ? $options['format'] : null);

		// use strpos, becase 2 comma-separated formats could be specified
		if ($value == '' && strpos($format, 'no_default') === false) { // try to get default language value
			$def_lang_value = $object->GetDBField('l'.$this->Application->GetDefaultLanguageId().'_'.$master_field);
			if ($def_lang_value == '') {
				return NULL;
			}

			return $this->_replaceFCKLinks($def_lang_value, $options, $format); //return value from default language
		}

		return $this->_replaceFCKLinks($value, $options, $format);
	}

	/**
	 * Performs required field check on primary language
	 *
	 * @param mixed $value
	 * @param string $field_name
	 * @param kDBItem $object
	 * @return string
	 */
	function Parse($value, $field_name, &$object)
	{
		if ($value == '') return NULL;

		return $value;
	}
}