<?php
/**
* @version	$Id: spam_helper.php 14241 2011-03-16 20:24:35Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class SpamHelper extends kHelper {

		/**
		 * Table name where spam control information is keeped
		 *
		 * @var string
		 */
		var $TableName;

		/**
		 * RecourceId field of current item
		 *
		 * @var int
		 */
		var $ResourceId = 0;

		/**
		 * ResourceId from all items in list
		 *
		 * @var Array
		 */
		var $ListResourceIDs = Array ();

		/**
		 * Type of information to put into spam control
		 *
		 * @var string
		 */
		var $DataType = '';

		/**
		 * Default spam control record expiration
		 *
		 * @var int
		 */
		var $Expiration = 0;

		var $ExpirationCache = Array ();

		function SpamHelper()
		{
			parent::kHelper();
			$this->TableName = TABLE_PREFIX.'SpamControl';
		}

		/**
		 * Initializes helper for concrete item
		 *
		 * @param int $resource_id
		 * @param string $data_type
		 * @param int $expiration
		 */
		function InitHelper($resource_id, $data_type, $expiration, $list_resource_ids = Array ())
		{
			$this->DataType = $data_type;
			$this->ResourceId = $resource_id;
			$this->ListResourceIDs = $list_resource_ids ? $list_resource_ids : Array ($resource_id);

			if (preg_match('/(.*):(.*)/', $expiration, $regs)) {
				$delay_value = $this->Application->ConfigValue($regs[1]);
				$delay_interval = $this->Application->ConfigValue($regs[2]);
				$expiration = $delay_value * $delay_interval;
			}

			$this->Expiration = adodb_mktime() + $expiration;
		}

		/**
		 * Returns WHERE clause that identified each spam control record
		 *
		 * @param bool $as_array return result as array, not string
		 *
		 * @return string
		 */
		function GetKeyClause($as_array = false)
		{
			$user_id = $this->Application->RecallVar('user_id');

			if ($user_id == 0) {
				$user_id = USER_GUEST;
			}

			$keys = Array (
				'IPaddress'			=>	$_SERVER['REMOTE_ADDR'],
				'PortalUserId'		=>	$user_id,
				'DataType'			=>	$this->DataType,
			);

			if ($as_array) {
				$keys['ItemResourceId'] = $this->ResourceId;

				return $keys;
			}

			$ret = '';
			foreach ($keys as $field_name => $field_value) {
				$ret .= '(' . $field_name . ' = ' . $this->Conn->qstr($field_value) . ') AND ';
			}

			$ret .= '(ItemResourceId IN (' . implode(',', $this->ListResourceIDs) . '))';

			return $ret;
		}

		/**
		 * Allows to add current item in spam control
		 *
		 */
		function AddToSpamControl()
		{
			$fields_hash = $this->GetKeyClause(true);

			$fields_hash['Expire'] = $this->Expiration;
			$this->Conn->doInsert($fields_hash, $this->TableName);

			if (!array_key_exists($this->DataType, $this->ExpirationCache)) {
				$this->ExpirationCache[$this->DataType][$this->ResourceId] = $this->Expiration;
			}
		}

		/**
		 * Allows to check if current item is in spam control
		 *
		 * @return bool
		 */
		function InSpamControl()
		{
			if (!array_key_exists($this->DataType, $this->ExpirationCache)) {
				$key_clause = $this->GetKeyClause();

				$sql = 'SELECT Expire, ItemResourceId
						FROM '.$this->TableName.'
						WHERE '.$key_clause;
				$this->ExpirationCache[$this->DataType] = $this->Conn->GetCol($sql, 'ItemResourceId');
			}

			$cache =& $this->ExpirationCache[$this->DataType];
			$expires = array_key_exists($this->ResourceId, $cache) ? $cache[$this->ResourceId] : false;

			if ($expires && $expires < adodb_mktime()) {
				// spam control record is expired
				$sql = 'DELETE FROM '.$this->TableName.'
						WHERE '.$key_clause;
				$this->Conn->Query($sql);
				return false;
			}

			return $expires ? true : false;
		}
	}