<?php
/**
* @version	$Id: site_helper.php 14241 2011-03-16 20:24:35Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2010 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class SiteHelper extends kHelper {

		/**
		 * Returns default country
		 *
		 * @return string
		 */
		function getDefaultCountry($country_prefix = '', $iso_format = true)
		{
			$country = $this->Application->siteDomainField($country_prefix . 'Country');

			if ($iso_format && !$country) {
				$country = 'USA';
			}

			if (!$iso_format && strlen($country)) {
				return $this->getCountryId($country);
			}

			return $country;
		}

		/**
		 * Returns country id based on it's ISO code
		 *
		 * @param string $iso_code
		 * @return int
		 */
		function getCountryId($iso_code)
		{
			static $cache = null;

			if (!isset($cache)) {
				$sql = 'SELECT CountryStateId, IsoCode
						FROM ' . $this->Application->getUnitOption('country-state', 'TableName') . '
						WHERE Type = ' . DESTINATION_TYPE_COUNTRY;
				$cache = $this->Conn->GetCol($sql, 'IsoCode');
			}

			return $cache[$iso_code];
		}

		/**
		 * Gets site domains from cache
		 *
		 * @return Array
		 */
		function getSiteDomains()
		{
			static $cache = null;

			if (!isset($cache)) {
				if ($this->Application->isCachingType(CACHING_TYPE_MEMORY)) {
					$cache = $this->Application->getCache('master:domains_parsed', false);
				}
				else {
					$cache = $this->Application->getDBCache('domains_parsed');
				}

				if ($cache) {
					$cache = unserialize($cache);
				}
				else {
					$sql = 'SELECT *
							FROM ' . TABLE_PREFIX . 'SiteDomains
							ORDER BY Priority DESC';
					$cache = $this->Conn->Query($sql, 'DomainId');

					if ($this->Application->isCachingType(CACHING_TYPE_MEMORY)) {
						$this->Application->setCache('master:domains_parsed', serialize($cache));
					}
					else {
						$this->Application->setDBCache('domains_parsed', serialize($cache));
					}
				}
			}

			return $cache;
		}

		/**
		 * Try to match visited domain to any of existing
		 *
		 * @param string $field
		 * @param string $value
		 * @return int
		 */
		function getDomainByName($field, $value)
		{
			$site_domains = $this->getSiteDomains();
			$name_fields = Array ('DomainName', 'SSLUrl');

			foreach ($site_domains as $id => $site_domain) {
				if ( in_array($field, $name_fields) ) {
					if (!$site_domain[$field . 'UsesRegExp']) {
						// not regular expression -> escape manually
						$site_domain[$field] = preg_quote($site_domain[$field], '/');
					}

					if (preg_match('/^' . $site_domain[$field] . ($field == 'DomainName' ? '$' : '') . '/', $value)) {
						return $id;
					}
				}
				elseif ($site_domain[$field] == $value) {
					return $id;
				}
			}

			return false;
		}

		/**
		 * Try to match domain settings based on visitor's IP address
		 *
		 * @return int
		 */
		function getDomainByIP()
		{
			$site_domains = $this->getSiteDomains();

			foreach ($site_domains as $id => $site_domain) {
				if (ipMatch($site_domain['DomainIPRange'], "\n")) {
					return $id;
				}
			}

			return false;
		}
	}
