<?php
/**
* @version	$Id: files_config.php 14241 2011-03-16 20:24:35Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => '#file',
		'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'FileEventHandler', 'file' => 'file_eh.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'FileTagProcessor', 'file' => 'file_tp.php', 'build_event' => 'OnBuild'),

		'AutoLoad' => true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'PerPage',
			4 => 'event',
		),

		'IDField' => 'FileId',
		'StatusField' => Array('Status'),

		'TitleField' => 'FileName',
		'TableName' => TABLE_PREFIX.'ItemFiles',

		'ParentTableKey' => 'ResourceId',
		'ForeignKey' => 'ResourceId',
		'AutoDelete' => true,
		'AutoClone' => true,

		'ListSQLs' => Array (
			'' => 'SELECT * FROM %s',
		),

		'ItemSQLs' => Array (
			'' => 'SELECT * FROM %s',
		),

		'ListSortings' => Array (
			'' => Array (
				'Sorting' => Array ('FileName' => 'asc'),
			)
		),

		'Fields' => Array (
			'FileId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'ResourceId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'FileName' => Array ('type' => 'string', 'max_len' => 255, 'required' => 1, 'not_null' => 1, 'default' => ''),
			'FilePath' => Array (
				'type' => 'string', 'max_len' => 255,
				'formatter' => 'kUploadFormatter', 'upload_dir' => ITEM_FILES_PATH, 'include_path' => false,
				'size_field' => 'Size', 'content_type_field' => 'MimeType', 'max_size' => 50000000,
				'allowed_types' => Array (
					'video/x-flv', 'video/quicktime', 'video/x-sgi-movie', 'video/mpeg',
					'video/x-msvideo', 'video/x-msvideo', 'application/x-shockwave-flash', 'video/x-fli',
					'application/pdf', 'application/msexcel', 'application/vnd.ms-excel', 'application/msword',
					'application/mspowerpoint', 'application/zip', 'text/plain', 'application/x-gzip',
				),
				'not_null' => 1, 'required' => 1, 'default' => ''
			),
			'Size' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'Status' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter',
				'options' => Array (1 => 'la_Enabled', 0 => 'la_Disabled'), 'use_phrases' => 1,
				'not_null' => 1, 'default' => 1,
			),
			'CreatedOn' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#'),
			'CreatedById' => Array ('type' => 'int', 'default' => NULL),
			'MimeType' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
		),

		'Grids' => Array (
			'Default' => Array (
				'Icons' => Array (1 => 'icon16_item.png', 0 => 'icon16_disabled.png'),
				'Fields' => Array(
					'FileId' => Array ('title' => 'la_col_Id' , 'data_block' => 'grid_checkbox_td', 'module' => 'In-Portal', 'filter_block' => 'grid_range_filter'),
					'FileName' => Array ('title' => 'la_col_FileName', 'filter_block' => 'grid_like_filter'),
					'Status' => Array ('title' => 'la_col_Status', 'filter_block' => 'grid_options_filter'),
				),
			),
		),
	);