<?php
/**
* @version	$Id: thesaurus_config.php 14241 2011-03-16 20:24:35Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'thesaurus',
		'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'ThesaurusEventHandler', 'file' => 'thesaurus_eh.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'ThesaurusTagProcessor', 'file' => 'thesaurus_tp.php', 'build_event' => 'OnBuild'),

		'AutoLoad' => true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'PerPage',
			4 => 'event',
			5 => 'mode',
		),

		'IDField' => 'ThesaurusId',

		'TableName' => TABLE_PREFIX.'Thesaurus',

		'TitleField' => 'SearchTerm',

		'TitlePresets' => Array (
			'default' => Array (
				'new_status_labels' => Array ('thesaurus' => '!la_title_AddingThesaurus!'),
				'edit_status_labels' => Array ('thesaurus' => '!la_title_EditingThesaurus!'),
			),

			'thesaurus_list' => Array (
				'prefixes' => Array ('thesaurus_List'), 'format' => "!la_title_Thesaurus!",
				'toolbar_buttons' => Array ('new_item', 'edit', 'delete', 'export', 'view', 'dbl-click'),
				),

			'thesaurus_edit' => Array (
				'prefixes' => Array ('thesaurus'), 'format' => "#thesaurus_status# '#thesaurus_titlefield#'",
				'toolbar_buttons' => Array ('select', 'cancel', 'reset_edit', 'prev', 'next'),
				),
		),

		'PermSection' => Array('main' => 'in-portal:thesaurus'),

		'Sections' => Array (
			'in-portal:thesaurus' => Array (
				'parent'		=>	'in-portal:website_setting_folder',
				'icon'			=>	'conf_thesaurus',
				'label'			=>	'la_title_Thesaurus',
				'url'			=>	Array('t' => 'thesaurus/thesaurus_list', 'pass' => 'm'),
				'permissions'	=>	Array('view', 'add', 'edit', 'delete'),
				'priority'		=>	9,
				'type'			=>	stTREE,
			),
		),

		'ListSQLs' => Array (
			'' => '	SELECT %1$s.* %2$s FROM %1$s',
		),

		'ListSortings' => Array (
			'' => Array (
				'Sorting' => Array ('SearchTerm' => 'asc'),
			)
		),

		'Fields' => Array (
			'ThesaurusId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'SearchTerm' => Array ('type' => 'string', 'max_len' => 255, 'required' => 1, 'not_null' => 1, 'default' => ''),
		    'ThesaurusTerm' => Array ('type' => 'string', 'max_len' => 255,  'required' => 1, 'not_null' => 1, 'default' => ''),
		    'ThesaurusType' => Array (
		    	'type' => 'int',
		    	'formatter' => 'kOptionsFormatter', 'options' => Array (
		    		0 => 'NT',
//		    		1 => 'RT',
//		    		2 => 'USE'
		    	),
		    	'not_null' => 1,  'required' => 1, 'default' => 0
		    ),
		),

		'Grids' => Array (
			'Default' => Array (
				'Icons' => Array (
					'default' => 'icon16_item.png',
					0 => 'icon16_disabled.png',
					1 => 'icon16_item.png',
				),
				'Fields' => Array (
					'ThesaurusId' => Array ('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 70, ),
					'SearchTerm' => Array ('title' => 'la_col_SearchTerm', 'filter_block' => 'grid_like_filter', 'width' => 250, ),
					'ThesaurusTerm' => Array ('title' => 'la_col_ThesaurusTerm', 'filter_block' => 'grid_like_filter', 'width' => 250, ),
//					'ThesaurusType' => Array ('title' => 'la_col_ThesaurusType', 'filter_block' => 'grid_options_filter',),
				),
			),
		),
	);