<?php
/**
* @version	$Id: modules_event_handler.php 14241 2011-03-16 20:24:35Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class ModulesEventHandler extends kDBEventHandler {

		/**
		 * Builds item
		 *
		 * @param kEvent $event
		 * @access protected
		 */
		function OnItemBuild(&$event)
		{
			$this->Application->SetVar($event->getPrefixSpecial(true).'_id', $event->Special);
			parent::OnItemBuild($event);
		}

		/**
		 * List with one record if special passed
		 *
		 * @param kEvent $event
		 */
		function SetCustomQuery(&$event)
		{
			$object =& $event->getObject();
			if ($event->Special) {
				$object->addFilter('current_module', 'Name = '.$event->Special);
			}

			$object->addFilter('not_core', '%1$s.Name <> "Core"');
		}

		function mapEvents()
		{
			parent::mapEvents();
			$this->eventMethods['OnMassApprove'] = 'moduleAction';
			$this->eventMethods['OnMassDecline'] = 'moduleAction';
		}

		/**
		 * Disabled modules, but not In-Portal
		 *
		 * @param kEvent $event
		 */
		function moduleAction(&$event)
		{
			if ($this->Application->CheckPermission('SYSTEM_ACCESS.READONLY', 1)) {
				$event->status = erFAIL;
				return ;
			}

			$object =& $event->getObject( Array('skip_autoload' => true) );
			/* @var $object kDBItem */

			$ids = $this->StoreSelectedIDs($event);

			if (!$ids) {
				return ;
			}

			$updated = 0;
			$status_field = $this->Application->getUnitOption($event->Prefix, 'StatusField');
			$status_field = array_shift($status_field);

			foreach ($ids as $id) {
				$object->Load($id);

				if (in_array($id, Array ('In-Portal', 'Core')) || !$object->isLoaded()) {
					// don't allow any kind of manupulations with kernel
					// approve/decline on not installed module
					continue;
				}

				$enabled = $event->Name == 'OnMassApprove' ? 1 : 0;
				$object->SetDBField($status_field, $enabled);

				if (!$object->GetChangedFields()) {
					// no changes -> skip
					continue;
				}

				if ($object->Update()) {
					$updated++;

					$sql = 'UPDATE ' . TABLE_PREFIX . 'ImportScripts
							SET Status = ' . $enabled . '
 							WHERE Module = "' . $object->GetDBField('Name') . '"';
 					$this->Conn->Query($sql);
				}
				else {
					$event->status = erFAIL;
					$event->redirect = false;
					break;
				}
			}

			if ($updated) {
				$event->status = erSUCCESS;
				$event->redirect_params = Array ('opener' => 's'); //stay!

				$this->Application->UnitConfigReader->ResetParsedData(true); //true to reset sections cache also
				$event->SetRedirectParam('RefreshTree', 1);
			}
		}

		/**
		 * Occures after list is queried
		 *
		 * @param kEvent $event
		 */
		function OnAfterListQuery(&$event)
		{
			parent::OnAfterListQuery($event);

			$new_modules = $this->_getNewModules();
			if (!$new_modules || $this->Application->RecallVar('user_id') != USER_ROOT) {
				return ;
			}

			require_once FULL_PATH . '/core/install/install_toolkit.php';

			$toolkit = new kInstallToolkit();

			$object =& $event->getObject();
			/* @var $object kDBList */

			foreach ($new_modules as $module) {
				$module_record = Array (
					'Name' => $toolkit->getModuleName($module),
					'Path' => 'modules/' . $module . '/',
					'Version' => $toolkit->GetMaxModuleVersion('modules/' . $module . '/'),
					'Loaded' => 0,
					'BuildDate' => null,
				);

				$object->addRecord($module_record);
			}
		}

		/**
		 * Returns list of modules, that are not installed, but available in file system
		 *
		 * @return Array
		 */
		function _getNewModules()
		{
			$modules_helper =& $this->Application->recallObject('ModulesHelper');
			/* @var $modules_helper kModulesHelper */

			$modules = Array ();
			if ($dir = @opendir(MODULES_PATH)) {
				while (($file = readdir($dir)) !== false) {
					if ($file != '.' && $file != '..') {
						$module_folder = MODULES_PATH . '/' . $file;
						if (is_dir($module_folder) && $this->_isModule($module_folder)) {
							// this is module -> check if it's installed already
							if (!$modules_helper->moduleInstalled($file)) {
								$install_order = trim( file_get_contents($module_folder . '/install/install_order.txt') );
								$modules[$install_order] = $file;
							}
						}
					}
				}

				closedir($dir);
			}

			// allows to control module install order
			ksort($modules, SORT_NUMERIC);
			return $modules;
		}

		/**
		 * Checks, that given folder is module root folder
		 *
		 * @param string $folder
		 * @return bool
		 */
		function _isModule($folder)
		{
			return file_exists($folder . '/install.php') && file_exists($folder . '/install/install_schema.sql');
		}
	}