<?php
/**
* @version	$Id: content_config.php 14241 2011-03-16 20:24:35Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'content',
		'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'ContentEventHandler', 'file' => 'content_eh.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'kDBTagProcessor', 'file' => '', 'build_event' => 'OnBuild'),
		'AutoLoad' => true,
		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'PerPage',
			4 => 'event',
			5 => 'mode', // needed?
		),

		'IDField' => 'PageContentId',
		'ParentTableKey' => 'CategoryId',	// linked field in master table
		'ForeignKey' => 'PageId',	// linked field in subtable
		'ParentPrefix' => 'c',
		'AutoDelete' => true,
		'AutoClone' => true,

		'TitleField' => 'ContentNum',		// field, used in bluebar when editing existing item		
		
		'TitlePresets' => Array (
			'default' => Array (
				'new_status_labels' => Array ('content' => '!la_title_Adding_Content!'),
				'edit_status_labels' => Array ('content' => '!la_title_Editing_Content!'),
			),
			'content_edit' => Array ('prefixes' => Array ('content'), 'format' => '#content_status# - !la_title_General!'),
		),

		'TableName' => TABLE_PREFIX . 'PageContent',

		'ListSQLs' => Array ('' => 'SELECT * FROM %s'),
		'ListSortings'	=> 	Array (
			'' => Array (
				'Sorting' => Array ('ContentNum' => 'asc'),
			)
		),

		'Fields' => Array (
			'PageContentId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'ContentNum' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'PageId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'Content' => Array ('type' => 'string', 'formatter' => 'kMultiLanguage', 'using_fck' => 1, 'default' => ''),
		),

	);
