<?php
/**
* @version	$Id: show_cache.php 14241 2011-03-16 20:24:35Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

// comment line below for debugging parsed configs
//die('Restrictred use!');

$start = getmicrotime();

define('FULL_PATH', realpath(dirname(__FILE__).'/..'));
define('REL_PATH', 'tools/');
define('ADMIN', 0);

include_once(FULL_PATH.'/core/kernel/startup.php');

$application =& kApplication::Instance();
$application->Init();

if (!$application->isDebugMode()) {
	die('Restrictred use!');
}

$show_var = $application->GetVar('show_var');

if ($show_var) {
	$var_data = $application->getDBCache($show_var);

	if ($var_data === false) {
		echo 'Not Found';
	}
	else {
		print_pre( unserialize($var_data), 'Cache "' . $show_var . '" content:', true);
	}
}
else {
	$sql = 'SELECT VarName
			FROM ' . TABLE_PREFIX . 'Cache';

	$var_names = $application->Conn->GetCol($sql);

	foreach ($var_names as $index => $var_name) {
		$var_names[$index] = '<a href="' . $application->BaseURL() . REL_PATH. 'show_cache.php?show_var=' . $var_name . '">' . $var_name . '</a>';
	}

	print_pre( $var_names, 'Cache variable names:', true);
}

$application->Done();

$end = getmicrotime();

function getmicrotime()
{
    list($usec, $sec) = explode(" ", microtime());
    return ((float)$usec + (float)$sec);
}