<?php
/**
* @version	$Id: pdf_renderer_zend.php 14241 2011-03-16 20:24:35Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

exit;

require_once 'Zend/Pdf.php';
class kZendPDFRenderer extends kPDFRenderer  {
	public $PDF = null;

	/**
	 * Enter description here...
	 *
	 * @var Zend_Pdf_Page
	 */
	public $CurPage = null;

	public $CurFont = null;
	public $CurFontSize = null;

	function __construct()
	{
		$this->PDF = new Zend_Pdf();
		$this->PDF->pages[] = ($page1 = new Zend_Pdf_Page(Zend_Pdf_Page::SIZE_A4));
		$this->CurPage = $page1;
	}

	function GetWidth()
	{
		return $this->CurPage->getWidth();
	}

	function GetHeight()
	{
		return $this->CurPage->getHeight();
	}

	function SetFont($font, $size)
	{
		$mapping = array(
			'helvetica' => Zend_Pdf_Font::FONT_HELVETICA,
		);
		$use_font = Zend_Pdf_Font::FONT_TIMES;
		foreach ($mapping as $pattern => $zend_font) {
			if (preg_match('/^'.$pattern.'$/i', $font)) {
				$use_font = $zend_font;
				break;
			}
		}
		$this->CurFont = Zend_Pdf_Font::fontWithName($use_font);
		$this->CurFontSize = $size;
		return $this->CurPage->setFont($this->CurFont, $size);
	}

	function SetFontSize($size)
	{
		$this->SetFont($this->CurFont, $size);
	}

	function SetFillColor($color)
	{
		return $this->CurPage->setFillColor( new Zend_Pdf_Color_HTML($color) );
	}

	function SetLineColor($color)
	{
		return $this->CurPage->setLineColor( new Zend_Pdf_Color_HTML($color) );
	}

	function SetLineWidth($width)
	{
		return $this->CurPage->setLineWidth($width);
	}

	function DrawLine($x1, $y1, $x2, $y2)
	{
		return $this->CurPage->drawLine($x1, $y1, $x2, $y2);
	}

	function DrawRectangle($x1, $y1, $x2, $y2, $mode)
	{
		return $this->CurPage->drawRectangle($x1, $y1, $x2, $y2, $mode);
	}

	function DrawText($x, $y, $text)
	{
		return $this->CurPage->drawText($x, $y, $text);
	}

	function GetPDFString()
	{
		return $this->PDF->render();
	}

	function GetAscent()
	{
		return ($this->CurFont->getAscent() / $this->CurFont->getUnitsPerEm()) * $this->CurFontSize;
	}

	function GetDescent()
	{
		return ($this->CurFont->getDescent() / $this->CurFont->getUnitsPerEm()) * $this->CurFontSize;
	}

	function GetLineGap()
	{
		return ($this->CurFont->getLineGap() / $this->CurFont->getUnitsPerEm()) * $this->CurFontSize;
	}

	function GetStringWidth($string)
	{
		$drawingString = iconv('UTF-8', 'UTF-16BE//IGNORE', $string);
		$characters = array();
		for ($i = 0; $i < strlen($drawingString); $i++) {
			$characters[] = (ord($drawingString[$i++]) << 8) | ord($drawingString[$i]);
		}
		$glyphs = $this->CurFont->cmap->glyphNumbersForCharacters($characters);
		$widths = $this->CurFont->widthsForGlyphs($glyphs);
		return (array_sum($widths) / $this->CurFont->getUnitsPerEm()) * $this->CurFontSize;
	}
}