<inp2:adm_SetPopupSize width="875" height="650"/>

<inp2:m_include t="incs/header"/>
<inp2:m_RenderElement name="combined_header" section="in-portal:configemail" prefix="emailevents" title_preset="email_message_edit_settings" tab_preset="Default"/>

<!-- ToolBar -->
<table class="toolbar" height="30" cellspacing="0" cellpadding="0" width="100%" border="0">
<tbody>
	<tr>
  	<td>
  		<script type="text/javascript">
				a_toolbar = new ToolBar();
				a_toolbar.AddButton( new ToolBarButton('select', '<inp2:m_phrase label="la_ToolTip_Save" escape="1"/>', function() {
							submit_event('emailevents','<inp2:emailevents_SaveEvent/>');
						}
					) );

				a_toolbar.AddButton( new ToolBarButton('cancel', '<inp2:m_phrase label="la_ToolTip_Cancel" escape="1"/>', function() {
							cancel_edit('emailevents','OnCancelEdit','<inp2:emailevents_SaveEvent/>','<inp2:m_Phrase label="la_FormCancelConfirmation" escape="1"/>');
						}
				 ) );


				a_toolbar.AddButton( new ToolBarButton('reset_edit', '<inp2:m_phrase label="la_ToolTip_Reset" escape="1"/>', function() {
						reset_form('emailevents', 'OnReset', '<inp2:m_Phrase label="la_FormResetConfirmation" escape="1"/>');
					}
			 	) );

				<inp2:m_if check="emailevents_IsSingle" inverse="inverse">
					a_toolbar.AddButton( new ToolBarSeparator('sep1') );
				</inp2:m_if>

				a_toolbar.AddButton( new ToolBarButton('prev', '<inp2:m_phrase label="la_ToolTip_Prev" escape="1"/>', function() {
							go_to_id('emailevents', '<inp2:emailevents_PrevId/>');
						}
				 ) );
				a_toolbar.AddButton( new ToolBarButton('next', '<inp2:m_phrase label="la_ToolTip_Next" escape="1"/>', function() {
							go_to_id('emailevents', '<inp2:emailevents_NextId/>');
						}
				 ) );

				a_toolbar.Render();

				<inp2:m_RenderElement name="edit_navigation" prefix="emailevents"/>
			</script>
		</td>

		<inp2:m_RenderElement name="ml_selector" prefix="emailevents"/>
	</tr>
</tbody>
</table>

<inp2:emailevents_SaveWarning name="grid_save_warning"/>
<inp2:emailevents_ErrorWarning name="form_error_warning"/>

<inp2:m_DefineElement name="inp_edit_combo_target" caption_render_as="default_field_caption_element" read_only="0" has_empty="" hint_label="">
	<inp2:m_RenderElement design="form_row" pass_params="1">
		<td class="control-cell">
			<inp2:m_if check="m_Param" name="read_only">
				<inp2:$prefix_Field name="{$field}Type"/>: "<inp2:$prefix_Field name="$field"/>"
			<inp2:m_else/>
				<select tabindex="<inp2:m_get param='tab_index'/>" name="<inp2:{$prefix}_InputName field='{$field}Type'/>" id="<inp2:{$prefix}_InputName field='{$field}Type'/>">
					<inp2:{$prefix}_PredefinedOptions field="{$field}Type" block="inp_option_phrase" selected="selected" has_empty="$has_empty"/>
				</select>

				<input type="text" name="<inp2:{$prefix}_InputName field='$field'/>" id="<inp2:{$prefix}_InputName field='$field'/>" value="<inp2:{$prefix}_Field field='$field'/>" tabindex="<inp2:m_get param='tab_index'/>" style="width: 250px;"/>
			</inp2:m_if>

			<script type="text/javascript">
				fields['<inp2:m_Param name="prefix" js_escape="1"/>']['<inp2:m_Param name="field" js_escape="1"/>Type'] = '<inp2:m_phrase label="{$title}Type" js_escape="1"/>'

				new AJAXDropDown(
					'<inp2:$prefix_InputName name="$field" js_escape="1"/>',
					function(cur_value) {
						var $type = $( jq('#<inp2:$prefix_InputName name="{$field}Type" js_escape="1"/>') ).val();

						if ( !isNaN( parseInt($type) ) ) {
							var $url = '<inp2:m_Link template="dummy" pass="m,$prefix" {$prefix}_event="OnSuggestAddress" value="#VALUE#" type="#TYPE#" no_amp="1"/>';

							return $url.replace('#VALUE#', encodeURIComponent(cur_value)).replace('#TYPE#', encodeURIComponent($type));
						}

						return false;
					}
				);

				$(document).ready(
					function () {
						$( jq('#<inp2:$prefix_InputName name="{$field}Type"/>') ).change(
							function ($e) {
								var $me = $(this);

								if ($me.attr('disabled')) {
									return ;
								}

								var $type_selected = !isNaN( parseInt( $me.val() ) );
								$( jq('#<inp2:$prefix_InputName name="$field"/>') ).attr('disabled', $type_selected ? '' : 'disabled');
							}
						)
						.change();
					}
				);
			</script>
		</td>
	</inp2:m_RenderElement>
</inp2:m_DefineElement>

<div id="scroll_container">
	<table class="edit-form">
		<inp2:m_RenderElement name="subsection" prefix="emailevents" fields="AllowChangingSender,CustomSender,SenderAddress,SenderAddressType,SenderName" title="la_section_SenderInfo"/>
			<inp2:m_if check="m_IsDebugMode">
				<inp2:m_RenderElement name="inp_edit_checkbox" prefix="emailevents" field="AllowChangingSender" title="la_fld_AllowChangingSender"/>
			</inp2:m_if>

			<inp2:m_if check="emailevents_IsEditable" check_field="AllowChangingSender">
				<inp2:m_RenderElement name="inp_edit_radio" prefix="emailevents" field="CustomSender" title="la_fld_CustomSender"/>
				<inp2:m_RenderElement name="inp_edit_combo_target" prefix="emailevents" field="SenderAddress" title="la_fld_SenderAddress" has_empty="1"/>
				<inp2:m_RenderElement name="inp_edit_box" prefix="emailevents" field="SenderName" title="la_fld_SenderName" style="width: 318px;"/>
			<inp2:m_else/>
				<inp2:m_RenderElement name="inp_label" prefix="emailevents" field="CustomSender" title="la_fld_CustomSender"/>
				<inp2:m_RenderElement name="inp_edit_combo_target" prefix="emailevents" field="SenderAddress" title="la_fld_SenderAddress" read_only="1"/>
				<inp2:m_RenderElement name="inp_label" prefix="emailevents" field="SenderName" title="la_fld_SenderName"/>
			</inp2:m_if>

		<inp2:m_RenderElement name="subsection" prefix="emailevents" fields="AllowChangingRecipient,CustomRecipient,RecipientType,RecipientAddress,RecipientAddressType,RecipientName,Recipients" title="la_section_RecipientsInfo"/>
			<inp2:m_if check="m_IsDebugMode">
				<inp2:m_RenderElement name="inp_edit_checkbox" prefix="emailevents" field="AllowChangingRecipient" title="la_fld_AllowChangingRecipient"/>
			</inp2:m_if>

			<inp2:m_if check="emailevents_IsEditable" check_field="AllowChangingRecipient">
				<inp2:m_RenderElement name="inp_edit_radio" prefix="emailevents" field="CustomRecipient" title="la_fld_CustomRecipient"/>
			<inp2:m_else/>
				<inp2:m_RenderElement name="inp_label" prefix="emailevents" field="CustomRecipient" title="la_fld_CustomRecipient"/>
				<inp2:emailevents_RemoveToRecipientType/>
			</inp2:m_if>

			<inp2:m_RenderElement name="inp_edit_radio" prefix="emailevents" field="RecipientType" title="la_fld_RecipientType"/>
			<inp2:m_RenderElement name="inp_edit_combo_target" prefix="emailevents" field="RecipientAddress" title="la_fld_RecipientAddress" has_empty="1"/>
			<inp2:m_RenderElement name="inp_edit_box" prefix="emailevents" field="RecipientName" title="la_fld_RecipientName" style="width: 318px;"/>
			<inp2:m_RenderElement name="inp_edit_minput" prefix="emailevents" field="Recipients" title="la_fld_Recipients" format="auto" style="width: 400px; height: 150px;"/>

		<inp2:m_RenderElement name="subsection" prefix="emailevents" fields="Tag,Replacement,ReplacementTagsXML" title="la_section_ReplacementTags"/>
			<inp2:m_RenderElement name="inp_edit_box" prefix="emailevents" field="Tag" title="la_fld_Tag"/>
			<inp2:m_RenderElement name="inp_edit_textarea" prefix="emailevents" field="Replacement" title="la_fld_Replacement"control_options="{height: 60}"/>
			<inp2:m_RenderElement name="inp_edit_minput" prefix="emailevents" field="ReplacementTagsXML" title="la_fld_ReplacementTags" allow_move="0" format="#Tag# = #Replacement#" style="width: 600px; height: 100px;"/>

		<inp2:m_RenderElement name="subsection" prefix="emailevents" fields="Enabled,Description,FrontEndOnly,Type,MessageType,Headers,Module" title="la_section_General"/>
			<inp2:m_if check="m_IsDebugMode">
				<inp2:m_RenderElement name="inp_edit_checkbox" prefix="emailevents" field="Enabled" title="la_fld_Enabled"/>
			</inp2:m_if>

			<inp2:m_RenderElement name="inp_edit_textarea" prefix="emailevents" field="Description" title="la_fld_Description" control_options="{max_height: 50}"/>
			<inp2:m_RenderElement name="inp_edit_checkbox" prefix="emailevents" field="FrontEndOnly" title="la_fld_FrontEndOnly"/>
			<inp2:m_RenderElement name="inp_edit_radio" prefix="emailevents" field="Type" title="la_fld_Type"/>
			<inp2:m_RenderElement name="inp_edit_radio" prefix="emailevents" field="MessageType" title="la_fld_MessageType"/>
			<inp2:m_RenderElement name="inp_edit_textarea" prefix="emailevents" field="Headers" title="la_fld_ExtraHeaders" control_options="{max_height: 50}"/>
			<inp2:m_RenderElement name="inp_edit_options" prefix="emailevents" field="Module" title="la_fld_Module" has_empty="1"/>
			<inp2:m_RenderElement name="inp_edit_filler"/>
	</table>
</div>

<script type="text/javascript">
	<inp2:m_if check="emailevents_FieldVisible" field="Recipients">
		// recipients
		Recipients.formatLine = function($record_index) {
			if (this.Records[$record_index]['RecipientName']) {
				// name specified
				if (this.Records[$record_index]['RecipientAddressType'] == 1) {
					// email
					this.ResultMask = '#RecipientType#: "#RecipientName#" <#RecipientAddress#>';
				}
				else {
					// other
					this.ResultMask = '#RecipientType#: "#RecipientName#" <#RecipientAddress#> - #RecipientAddressType#';
				}
			}
			else {
				// name not specified
				this.ResultMask = '#RecipientType#: #RecipientAddress# - #RecipientAddressType#';
			}

			return MultiInputControl.prototype.formatLine.call(this, $record_index);
		}

		Recipients.compareRecords = function($record_a, $record_b) {
			var $equals = true;
			var $compare_fields = ['RecipientAddressType', 'RecipientAddress'];

			for (var $i = 0; $i < $compare_fields.length; $i++) {
				var $field_name = $compare_fields[$i];

				if ($record_a[$field_name] !== $record_b[$field_name]) {
					return false;
				}
			}

			return $equals;
		}

		<inp2:m_ifnot check="emailevents_IsEditable" check_field="AllowChangingRecipient">
			Recipients.isReadOnly = function($record_index) {
				return this.Records[$record_index]['RecipientType'] == <inp2:m_GetConst name="RECIPIENT_TYPE_TO"/>;
			}

			<inp2:emailevents_RestoreRecipientType/>
			Recipients.registerControl('RecipientType', {type: 'radio', required: true, options: <inp2:m_RenderElement name="inp_json_options" prefix="emailevents" field="RecipientType" strip_nl="2"/>, 'default': <inp2:m_GetConst name="RECIPIENT_TYPE_CC"/>});
		<inp2:m_else/>
			Recipients.registerControl('RecipientType', {type: 'radio', required: true, options: <inp2:m_RenderElement name="inp_json_options" prefix="emailevents" field="RecipientType" strip_nl="2"/>, 'default': <inp2:emailevents_FieldOption field="RecipientType" option="default"/>});
		</inp2:m_ifnot>

		Recipients.registerControl('RecipientAddressType', {type: 'select', required: true, options: <inp2:m_RenderElement name="inp_json_options" prefix="emailevents" field="RecipientAddressType" strip_nl="2"/>, 'default': <inp2:emailevents_FieldOption field="RecipientAddressType" option="default"/>});
		Recipients.registerControl('RecipientAddress', {type: 'textbox', required: true, 'default': '<inp2:emailevents_FieldOption field="RecipientAddress" option="default" js_escape="1"/>'});
		Recipients.registerControl('RecipientName', {type: 'textbox', required: false, 'default': '<inp2:emailevents_FieldOption field="RecipientName" option="default" js_escape="1"/>'});
		Recipients.LoadValues();
	</inp2:m_if>

	<inp2:m_if check="emailevents_FieldVisible" field="ReplacementTagsXML">
		// replacement tags
		ReplacementTagsXML.formatLine = function($record_index) {
			var $ret = MultiInputControl.prototype.formatLine.call(this, $record_index, false);

			if ($ret.length > 80) {
				$ret = $ret.substring(0, 80) + ' ...';
			}

			return this.htmlspecialchars($ret);
		}

		ReplacementTagsXML.compareRecords = function($record_a, $record_b) {
			return $record_a['Tag'] == $record_b['Tag'];
		}

		ReplacementTagsXML.registerControl('Tag', 'textbox', true);
		ReplacementTagsXML.registerControl('Replacement', 'textbox', true);
		ReplacementTagsXML.LoadValues();
	</inp2:m_if>

	// reflect custom sender & custom recipient radio button-dependent controls
	var $field_mask = '<inp2:emailevents_InputName name="#FIELD_NAME#" js_escape="1"/>';

	function reflectCustomSender() {
		var $default_sender = get_control($field_mask, 'CustomSender', '0').checked;
		var $type = get_control($field_mask, 'SenderAddressType');

		$type.disabled = $default_sender;
		get_control($field_mask, 'SenderAddress').disabled = $default_sender;
		get_control($field_mask, 'SenderName').disabled = $default_sender;

		$($type).change();
	}

	function reflectCustomRecipient() {
		<inp2:m_if check="emailevents_IsEditable" check_field="AllowChangingRecipient">
			var $default_recipient = get_control($field_mask, 'CustomRecipient', '0').checked;
			var $to_recipient = get_control($field_mask, 'RecipientType', <inp2:m_GetConst name="RECIPIENT_TYPE_TO"/>);
		<inp2:m_else/>
			var $default_recipient = <inp2:m_if check="emailevents_Field" name="CustomRecipient" db="db" equals_to="0">true<inp2:m_else/>false</inp2:m_if>;
		</inp2:m_if>

		if ($default_recipient) {
			<inp2:m_if check="emailevents_IsEditable" check_field="AllowChangingRecipient">
				if ($to_recipient.checked) {
					get_control($field_mask, 'RecipientType', <inp2:m_GetConst name="RECIPIENT_TYPE_CC"/>).checked = true;
				}
			</inp2:m_if>

			Recipients.registerControl('RecipientType', {'default': <inp2:m_GetConst name="RECIPIENT_TYPE_CC"/>}, true);
		}
		else {
			Recipients.registerControl('RecipientType', {'default': <inp2:m_GetConst name="RECIPIENT_TYPE_TO"/>}, true);
		}

		<inp2:m_if check="emailevents_IsEditable" check_field="AllowChangingRecipient">
			$to_recipient.disabled = $default_recipient;
		</inp2:m_if>
	}

	reflectCustomSender();
	reflectCustomRecipient();

	$(document).ready(
		function () {
			$("input[name='" + jq($field_mask.replace('#FIELD_NAME#', 'CustomSender')) + "']").click(reflectCustomSender);
			$("input[name='" + jq($field_mask.replace('#FIELD_NAME#', 'CustomRecipient')) + "']").click(reflectCustomRecipient);
		}
	);

	// enable all disabled controls before submit
	Application.setHook('emailevents:*',
		function () {
			$(':input:disabled').attr('disabled', '');
		}
	)
</script>

<inp2:m_include t="incs/footer"/>
