<?php
/**
* @version	$Id: form_fields_config.php 14241 2011-03-16 20:24:35Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config =	Array(
					'Prefix'			=>	'formflds',
					'ItemClass'			=>	Array('class'=>'kDBItem','file'=>'','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class'=>'FormFieldEventHandler','file'=>'form_field_eh.php','build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class'=>'FormFieldsTagProcessor','file'=>'form_fields_tp.php'),
					'AutoLoad'			=>	true,
					'QueryString'		=>	Array(
												1 => 'id',
												2 => 'Page',
												3 => 'PerPage',
												4 => 'event',
											),

					'IDField'			=>	'FormFieldId',
					'TitleField'		=>	'FieldName',
					'TableName'			=>	TABLE_PREFIX.'FormFields',
					'ListSQLs'	=>	Array(
							''=>'	SELECT %1$s.* %2$s FROM %1$s',
						), // key - special, value - list select sql
					'ItemSQLs'	=>	Array(
								''=>'SELECT %1$s.* %2$s FROM %1$s',
						),

					'ForeignKey'	=>	'FormId',
					'ParentTableKey' => 'FormId',
					'ParentPrefix' => 'form',
					'AutoDelete'	=>	true,
					'AutoClone'	=> true,

					'ListSortings'	=> 	Array(
												'' => Array(
													'Sorting' => Array('Name' => 'asc'),
												)
											),

					'ListSortings'	=> 	Array(
						'' => Array(
							'ForcedSorting' => Array('Priority' => 'desc'),
							'Sorting' => Array('FieldName' => 'asc'),
						)
					),

					'Fields'	=>	Array(
						'FormFieldId' => Array('type' => 'int', 'not_null' => 1, 'default' => 0),
						'FormId' => Array('type' => 'int', 'not_null' => 1, 'default' => 0),
			            'Type' => Array('type' => 'int', 'not_null' => 1, 'default' => 0),
			            'FieldName' => Array('type' => 'string', 'not_null' => 1, 'required' => 1, 'default' => ''),
			            'FieldLabel' => Array('type' => 'string', 'required' => 1, 'default' => null),
			            'Heading' => Array('type' => 'string', 'default' => null),
			            'Prompt' => Array('type' => 'string', 'default' => null, 'required' => 1),
			            'ElementType' => Array(
			            	'type' => 'string',
			            	'formatter' => 'kOptionsFormatter', 'options' => Array ('text' => 'la_type_text', 'select' => 'la_type_select', 'radio' => 'la_type_radio', 'checkbox' => 'la_type_SingleCheckbox', 'password' => 'la_type_password', 'textarea' => 'la_type_textarea', 'label' => 'la_type_label'), 'use_phrases' => 1,
			            	'required' => 1, 'not_null' => 1, 'default' => '',
			            ),
			            'ValueList' => Array('type' => 'string','default' => null),
			            'Priority' => Array('type' => 'int','not_null' => 1, 'default' => 0),
			            'IsSystem' => Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array(0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 0),
			            'Required' => Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array(0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 0),
			            'DisplayInGrid' => Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array(0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 1),
			            'DefaultValue' => Array('type' => 'string', 'default' => NULL),
			            'Validation' => Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array(0 => 'la_None', 1 => 'la_ValidationEmail'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 0),
			            'Visibility' => Array (
							'type' => 'int',
							'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_opt_Everyone', 2 => 'la_opt_GuestsOnly'), 'use_phrases' => 1,
							'not_null' => 1, 'default' => 1
						),
						'EmailCommunicationRole' => Array (
							'type' => 'int',
							'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_opt_RecipientName', 2 => 'la_opt_RecipientEmail', 3 => 'la_opt_EmailSubject', 4 => 'la_opt_EmailBody'), 'use_phrases' => 1,
							'not_null' => 1, 'default' => 0
						),
					),

					'VirtualFields'	=>	Array(
						'DirectOptions' =>	Array('type' => 'string', 'default' => ''),
					),

					'CalculatedFields'	=>	Array(
					),
					'Grids'	=> Array(
						'Default'		=>	Array(
							'Icons' => Array('default'=>'icon16_item.png'),
							'Fields' => Array(
								'FormFieldId' => Array( 'title'=>'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60 ),
								'FieldName' => Array( 'title'=>'la_prompt_FieldName', 'filter_block' => 'grid_like_filter', 'width' => 100 ),
								'FieldLabel' => Array( 'title'=>'la_prompt_FieldLabel', 'data_block' => 'label_grid_data_td', 'filter_block' => 'grid_like_filter', 'width' => 150 ),
								'Priority' => Array('title' => 'la_prompt_Priority', 'filter_block' => 'grid_range_filter', 'width' => 80 ),
								'ElementType' => Array('title' => 'la_prompt_ElementType', 'filter_block' => 'grid_options_filter'),
								'Required' => Array('title' => 'la_prompt_Required', 'filter_block' => 'grid_options_filter'),
								'DisplayInGrid' => Array('title' => 'la_prompt_DisplayInGrid', 'filter_block' => 'grid_options_filter', 'width' => 150 ),
								'Visibility' => Array('title' => 'la_col_Visibility', 'filter_block' => 'grid_options_filter', 'width' => 100),
								'EmailCommunicationRole' => Array('title' => 'la_col_EmailCommunicationRole', 'filter_block' => 'grid_options_filter', 'width' => 150),
							),
						),
					),
	);