<?php
/**
* @version	$Id: startup.php 14241 2011-03-16 20:24:35Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	define('KERNEL_PATH', FULL_PATH . '/core/kernel');

	if (!function_exists('getmicrotime')) {
		function getmicrotime()
		{
			list($usec, $sec) = explode(" ", microtime());
			return ((float)$usec + (float)$sec);
		}
	}

	$globals_start = getmicrotime();
	include_once(KERNEL_PATH . '/globals.php');	// non OOP functions used through kernel, e.g. print_pre
	include_once(KERNEL_PATH . '/utility/multibyte.php');	// emulating multi-byte php extension
	$globals_end = getmicrotime();

	$vars = parse_portal_ini();

	$admin_directory = isset($vars['AdminDirectory']) ? $vars['AdminDirectory'] : '/admin';
	define('ADMIN_DIRECTORY', $admin_directory);

	$admin_Presets_directory = isset($vars['AdminPresetsDirectory']) ? $vars['AdminPresetsDirectory'] : ADMIN_DIRECTORY;
	define('ADMIN_PRESETS_DIRECTORY', $admin_Presets_directory);

	# New path detection method: begin
	if (defined('REL_PATH')) {
		// location of index.php relatively to site base folder
		$relative_path = preg_replace('/^[\/]{0,1}admin(.*)/', $admin_directory . '\\1', REL_PATH);
	}
	else {
		// default index.php relative location is administrative console folder
		define('REL_PATH', $admin_directory);
		$relative_path = REL_PATH;
	}

	$ps = rtrim(preg_replace('/' . preg_quote(rtrim($relative_path, '/'), '/') . '$/', '', str_replace('\\', '/', dirname($_SERVER['PHP_SELF']))), '/');
	safeDefine('BASE_PATH', $ps); // in case in-portal has defined it before
	# New path detection method: end

	if ( array_key_exists('HTTP_HOST', $_SERVER) ) {
		// accessed from browser
		define('SERVER_NAME', $_SERVER['HTTP_HOST']);
	}
	else {
		// accessed from command line
		define('SERVER_NAME', $vars['Domain']);
		$_SERVER['HTTP_HOST'] = $vars['Domain'];
	}

	$https_mark = getArrayValue($_SERVER, 'HTTPS');
	safeDefine('PROTOCOL', ($https_mark == 'on') || ($https_mark == '1') ? 'https://' : 'http://');

	$port = array_key_exists('HTTP_PORT', $_SERVER) ? $_SERVER['HTTP_PORT'] : false;

	if ($port && ((PROTOCOL == 'http://' && $port != '80') || (PROTOCOL == 'https://' && $port != '443'))) {
		// if non-standard port is used, then define it
        define('PORT', $_SERVER['HTTP_PORT']);
    }

	safeDefine('APPLICATION_CLASS', isset($vars['ApplicationClass']) ? $vars['ApplicationClass'] : 'kApplication');
	safeDefine('APPLICATION_PATH', isset($vars['ApplicationPath']) ? $vars['ApplicationPath'] : '/core/kernel/application.php');

	if (isset($vars['WriteablePath'])) {
		define('WRITEABLE', FULL_PATH . $vars['WriteablePath']);
		define('WRITEBALE_BASE', $vars['WriteablePath']);
	}

	if ($vars === false || count($vars) == 0) {
		global $rootURL;
		echo 'In-Portal is probably not installed, or configuration file is missing.<br>';
		echo 'Please use the installation script to fix the problem.<br><br>';
		echo '<a href="' . PROTOCOL . SERVER_NAME . rtrim(BASE_PATH, '/') . '/core/install.php">Go to installation script</a><br><br>';
		flush();
		exit;
	}

	define('SQL_TYPE', $vars['DBType']);
	define('SQL_SERVER', $vars['DBHost']);
	define('SQL_USER', $vars['DBUser']);
	define('SQL_PASS', $vars['DBUserPassword']);
	define('SQL_DB', $vars['DBName']);

	if (isset($vars['DBCollation']) && isset($vars['DBCharset'])) {
		define('SQL_COLLATION', $vars['DBCollation']);
		define('SQL_CHARSET', $vars['DBCharset']);
	}
	define('TABLE_PREFIX', $vars['TablePrefix']);

	define('DOMAIN', getArrayValue($vars, 'Domain'));

	ini_set('memory_limit', '50M');

	define('MODULES_PATH', FULL_PATH . DIRECTORY_SEPARATOR . 'modules');

	define('EXPORT_BASE_PATH', WRITEBALE_BASE . '/export');
	define('EXPORT_PATH', FULL_PATH . EXPORT_BASE_PATH);

	define('GW_CLASS_PATH', MODULES_PATH . '/in-commerce/units/gateways/gw_classes'); // Payment Gateway Classes Path
	define('SYNC_CLASS_PATH', FULL_PATH . '/sync');	// path for 3rd party user syncronization scripts

	safeDefine('ENV_VAR_NAME','env');

	define('IMAGES_PATH', WRITEBALE_BASE . '/images/');
	define('IMAGES_PENDING_PATH', IMAGES_PATH . 'pending/');
	safeDefine('MAX_UPLOAD_SIZE', min(ini_get('upload_max_filesize'), ini_get('post_max_size'))*1024*1024);

	safeDefine('EDITOR_PATH', isset($vars['EditorPath']) ? $vars['EditorPath'] : '/core/editor/');

	// caching types
	define('CACHING_TYPE_NONE', 0);
	define('CACHING_TYPE_MEMORY', 1);
	define('CACHING_TYPE_TEMPORARY', 2);

	if (ini_get('safe_mode')) {
		// safe mode will be removed at all in PHP6
		define('SAFE_MODE', 1);
	}

	if (file_exists(WRITEABLE . '/debug.php')) {
		include_once(WRITEABLE . '/debug.php');
		if (array_key_exists('DEBUG_MODE', $dbg_options) && $dbg_options['DEBUG_MODE']) {
			$debugger_start = getmicrotime();
			include_once(KERNEL_PATH . '/utility/debugger.php');
			$debugger_end = getmicrotime();

			if (isset($debugger) && constOn('DBG_PROFILE_INCLUDES')) {
				$debugger->profileStart('inc_globals', KERNEL_PATH . '/globals.php', $globals_start);
				$debugger->profileFinish('inc_globals', KERNEL_PATH . '/globals.php', $globals_end);
				$debugger->profilerAddTotal('includes', 'inc_globals');

				$debugger->profileStart('inc_debugger', KERNEL_PATH . '/utility/debugger.php', $debugger_start);
				$debugger->profileFinish('inc_debugger', KERNEL_PATH . '/utility/debugger.php', $debugger_end);
				$debugger->profilerAddTotal('includes', 'inc_debugger');
			}
		}
	}

	safeDefine('SILENT_LOG', 0);

	$includes = Array(
			KERNEL_PATH . '/application.php',
			FULL_PATH . APPLICATION_PATH,
			KERNEL_PATH . '/db/db_connection.php',
			KERNEL_PATH . "/kbase.php",
			KERNEL_PATH . '/utility/event.php',
			KERNEL_PATH . "/utility/factory.php",
			KERNEL_PATH . "/languages/phrases_cache.php",
			KERNEL_PATH . "/db/dblist.php",
			KERNEL_PATH . "/db/dbitem.php",
			KERNEL_PATH . "/event_handler.php",
			KERNEL_PATH . '/db/db_event_handler.php',
	);

	foreach ($includes as $a_file) {
		k4_include_once($a_file);
	}

	if (defined('DEBUG_MODE') && DEBUG_MODE && isset($debugger)) {
		$debugger->AttachToApplication();
	}

	if( !function_exists('adodb_mktime') ) {
		include_once(KERNEL_PATH . '/utility/adodb-time.inc.php');
	}

	// system users
	define('USER_ROOT', -1);
	define('USER_GUEST', -2);