<?php
/**
* @version	$Id: user_profile_tp.php 14241 2011-03-16 20:24:35Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class UserProfileTagProcessor extends kDBTagProcessor {

		function Field($params)
		{
			$field = $this->SelectParam($params, 'name,field');
			$profile_mapping = $this->Application->getUnitOption('u', 'UserProfileMapping');
			$user_field = array_key_exists($field, $profile_mapping) ? $profile_mapping[$field] : false;

			if (array_key_exists('profile_field', $params) && $params['profile_field']) {
				// get variable from mapping
				$params['name'] = $user_field;
				$value = $this->Application->ProcessParsedTag('u.profile', 'Field', $params);
			}
			elseif ($user_field) {
				// old style variable for displaying fields in public profile (named "pp_*")
				$block_params = Array ('name' => 'DisplayToPublic',	'value' => $user_field);
				$value = $this->Application->ProcessParsedTag($this->getUserPrefixSpecial(), 'Selected', $block_params);
			}
			else {
				// get variable by name
				$value = $this->recallUserProfileVar($field);
			}

			if (isset($params['checked']) && $params['checked']) {
				$checked_value = isset($params['value']) ? $params['value'] : 1;
				$value = ($value == $checked_value) ? 'checked' : '';
			}

			return $value;
		}

		/**
		 * Returns prefix and special of user to operate with
		 *
		 * @return string
		 */
		function getUserPrefixSpecial()
		{
			return $this->Application->GetVar('user_id') ? 'u.profile' : 'u.current';
		}

		/**
		 * Allows to get persistent var from other user
		 *
		 * @param int $user_id
		 * @param string $var_name
		 * @return mixed
		 */
		function recallUserProfileVar($var_name)
		{
			static $cache = null;

			if (!isset($cache)) {
				$user =& $this->Application->recallObject( $this->getUserPrefixSpecial() );
				/* @var $user kDBItem */

				$sql = 'SELECT VariableValue, VariableName
						FROM ' . TABLE_PREFIX . 'PersistantSessionData
						WHERE (PortalUserId = ' . $user->GetID() . ')';
				$cache = $this->Conn->GetCol($sql, 'VariableName');
			}

			if (array_key_exists($var_name, $cache)) {
				// get variable value from persistent session
				return $cache[$var_name];
			}
			else {
				// not found in persistent session -> get default value from config variable with same name
				$config_value = $this->Application->ConfigValue($var_name);

				if ($config_value !== false) {
					return $config_value;
				}
			}

			return false;
		}



		/**
		 * Returns visible field count in user profile
		 *
		 * @param Array $params
		 * @return int
		 */
		function ProfileFieldCount($params)
		{
			static $field_count = null;

			if (!isset($field_count)) {
				$user =& $this->Application->recallObject( $this->getUserPrefixSpecial() );
				/* @var $user kDBItem */

				$display_to_public = $user->GetDBField('DisplayToPublic');
				$field_count = $display_to_public ? substr_count($display_to_public, '|') - 1 : 0;
			}

			return $field_count;
		}

		/**
		 * Allows to detect that not all fields were shown
		 *
		 * @param Array $params
		 * @return bool
		 */
		function NotLastField($params)
		{
			$counter = (int)$this->Application->GetVar($params['counter']);

			return $counter < $this->ProfileFieldCount();
		}

		/**
		 * Because of persistant session table doesn't have ids, we use user id as id for each record
		 *
		 * @param Array $params
		 * @return Array (id,field)
		 * @access private
		 */
		function prepareInputName($params)
		{
			$params['force_id'] = $this->Application->RecallVar('user_id');

			return parent::prepareInputName($params);
		}

	}