<?php
/**
* @version	$Id: user_groups_dbitem.php 14241 2011-03-16 20:24:35Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class UserGroups_DBItem extends kDBItem	{

		/**
		* Returns part of SQL WHERE clause identifing the record, ex. id = 25
		*
		* @access public
		* @param string $method Child class may want to know who called GetKeyClause, Load(), Update(), Delete() send its names as method
		* @return void
		* @see kDBItem::Load()
		* @see kDBItem::Update()
		* @see kDBItem::Delete()
		*/
		function GetKeyClause($method=null, $keys_hash = null)
		{
			$table_info = $this->getLinkedInfo($this->Special, true);
			if ($table_info) {
				// we have parent info, then use it
				$keys_hash = Array(
					$this->IDField				=>	$this->ID,
					$table_info['ForeignKey']	=>	$table_info['ParentId'],
				);
			}
			return parent::GetKeyClause($method, $keys_hash);
		}

	}