<?php
/**
* @version	$Id: custom_fields_config.php 14241 2011-03-16 20:24:35Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config =	Array(
					'Prefix'			=>	'cf',
					'ItemClass'			=>	Array('class'=>'kDBItem','file'=>'','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class'=>'CustomFieldsEventHandler','file'=>'custom_fields_event_handler.php','build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class'=>'CustomFieldsTagProcessor','file'=>'custom_fields_tag_processor.php','build_event'=>'OnBuild'),
					'AutoLoad'			=>	true,
					'hooks'				=>	Array(),
					'QueryString'		=>	Array(
												1	=>	'id',
												2	=>	'Page',
												3	=>	'PerPage',
												4	=>	'event',
												5	=>	'type',
												6	=>	'mode',
											),

					'Hooks'				=>	Array(
													Array(
														'Mode' => hAFTER,
														'Conditional' => false,
														'HookToPrefix' => 'cf',
														'HookToSpecial' => '*',
														'HookToEvent' => Array('OnSave'),	// edit cloned fields to made alters :)
														'DoPrefix' => 'cf',
														'DoSpecial' => '*',
														'DoEvent' => 'OnSaveCustomField',
													),
											),

					'IDField'			=>	'CustomFieldId',
					'OrderField'		=>	'DisplayOrder',

					'TitleField'		=>	'FieldName',		// field, used in bluebar when editing existing item

					'TitlePhrase'		=> 'la_title_CustomFields',

					'TitlePresets'		=>	Array(
												'default'	=>	Array(	'new_status_labels'		=> Array('cf'=>'!la_title_addingCustom!'),
																		'edit_status_labels'	=> Array('cf'=>'!la_title_Editing_CustomField!'),
																		'new_titlefield'		=> Array('cf'=>''),
																),

												'custom_fields_list'=>Array(	'prefixes'				=> Array('cf_List'),
																		'format'				=>	"!la_tab_ConfigCustom!",
																),

												'custom_fields_edit'=>Array(	'prefixes'				=> Array('cf'),
																		'new_titlefield'		=> Array('cf'=>''),
																		'format'				=> "#cf_status# '#cf_titlefield#'",
																),
											),

					'TableName'			=>	TABLE_PREFIX.'CustomField',

					'ListSQLs'			=>	Array(	''=>'SELECT * FROM %s',
																		), // key - special, value - list select sql

					'ListSortings'	=> 	Array(
												''			=>	Array(
																		'ForcedSorting' => Array('DisplayOrder' => 'asc'),
																		'Sorting' => Array('FieldName' => 'asc'),
																),

												'general'	=>	Array(
																	'Sorting' => Array('DisplayOrder' => 'asc')
																),

										),

					'ItemSQLs'			=>	Array(	''=>'SELECT * FROM %s',
																		),
					'SubItems'			=>	Array('confs-cf'),

					'Fields'			=>	Array (
										            'CustomFieldId' => Array('type' => 'int', 'not_null' => 1, 'default' => 0),
										            'Type' => Array('type' => 'int', 'not_null' => 1, 'default' => 0),
										            'FieldName' => Array('required'=>'1', 'type' => 'string','not_null' => 1,'default' => ''),
										            'FieldLabel' => Array('type' => 'string', 'required' => 1, 'default' => null),
										            'MultiLingual' => Array (
														'type' => 'int',
														'formatter' => 'kOptionsFormatter',
														'options' => Array (0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1,
														'not_null' => 1, 'default' => 1,
													),
										            'Heading' => Array('type' => 'string', 'required' => 1, 'default' => null),
										            'Prompt' => Array('type' => 'string','default' => null),
										            'ElementType' => Array('required'=>'1', 'type'=>'string', 'not_null'=>1, 'default'=>'', 'formatter'=>'kOptionsFormatter', 'use_phrases' => 1, 'options'=>Array('text' => 'la_type_text', 'select' => 'la_type_select', 'multiselect' => 'la_type_multiselect', 'radio' => 'la_type_radio', 'checkbox' => 'la_type_checkbox', 'password' => 'la_type_password', 'textarea' => 'la_type_textarea', 'label' => 'la_type_label', 'date' => 'la_type_date', 'datetime' => 'la_type_datetime')),
										            'ValueList' => Array('type' => 'string','default' => null),
										            'DefaultValue' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
										            'DisplayOrder' => Array('type' => 'int', 'not_null' => 1, 'default' => 0),
										            'OnGeneralTab' => Array (
														'type' => 'int',
														'formatter' => 'kOptionsFormatter',
														'options' => Array (0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1,
														'not_null' => 1, 'default' => 0,
													),
										            'IsSystem' => Array (
														'type' => 'int',
														'formatter' => 'kOptionsFormatter',
														'options' => Array (0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1,
														'not_null' => 1, 'default' => 0,
													),
										            'IsRequired' => Array (
														'type' => 'int',
														'formatter' => 'kOptionsFormatter',
														'options' => Array (0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1,
														'not_null' => 1, 'default' => 0,
													),
					),

					'VirtualFields'	=> 	Array(
													'Value'			=>	Array('type' => 'string', 'default' => ''),
													'OriginalValue'	=>	Array('type' => 'string', 'default' => ''),
													'Error'			=>	Array('type' => 'string', 'default' => ''),
													'DirectOptions' =>	Array('type' => 'string', 'default' => ''),

													'SortValues'	=>	Array (
														'type' => 'int',
														'formatter' => 'kOptionsFormatter',
														'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
														'default' => 0,
													),

													// for ValueList field editing via "inp_edit_minput" control
													'OptionKey' => Array ('type' => 'string', 'default' => ''),
													'OptionTitle' => Array ('type' => 'string', 'default' => ''),
													'Options' => Array ('type' => 'string', 'default' => ''),

										),

					'Grids'	=> Array(
										'Default' => Array (
											'Icons' => Array (
												'default' => 'icon16_item.png',
											),
											'Fields' => Array (
												'CustomFieldId' => Array ( 'title'=>'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 70, ),
												'FieldName' => Array ( 'title'=>'la_prompt_FieldName', 'width' => 250, ),
												'FieldLabel' => Array ( 'title'=>'la_prompt_FieldLabel', 'data_block' => 'cf_grid_data_td', 'width' => 250, ),
												'DisplayOrder' => Array ('title' => 'la_prompt_DisplayOrder', 'filter_block' => 'grid_range_filter', 'width' => 105, ),
//												'IsSystem' => Array ('title' => 'la_col_IsSystem', 'filter_block' => 'grid_options_filter'),
											),
										),

										'SeparateTab' => Array (
											'Icons' => Array (
												'default' => 'icon16_item.png',
											),
											'Selector' => '',
											'Fields' => Array (
												'FieldName' => Array ( 'title'=>'la_col_FieldName', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_like_filter', 'width' => 200, ),
												'Prompt' => Array ( 'title'=>'la_col_Prompt', 'data_block' => 'grid_data_label_ml_td', 'ElementTypeField' => 'ElementType', 'filter_block' => 'grid_empty_filter', 'width' => 200, ),
												'Value' => Array ( 'title'=>'la_col_Value', 'data_block' => 'edit_custom_td', 'filter_block' => 'grid_empty_filter', 'width' => 200, ),
												'Error' => Array ( 'title'=>'la_col_Error', 'data_block' => 'custom_error_td', 'filter_block' => 'grid_empty_filter', 'width' => 100, ),
											),
										),

										'SeparateTabOriginal' => Array (
											'Icons' => Array (
												'default' => 'icon16_item.png',
											),
											'Selector' => '',
											'Fields' => Array (
												'FieldName' => Array ( 'title'=>'la_col_FieldName', 'data_block' => 'grid_icon_td', 'filter_block' => 'grid_like_filter'),
												'Prompt' =>	Array ( 'title'=>'la_col_Prompt', 'data_block' => 'grid_data_label_ml_td', 'ElementTypeField' => 'ElementType', 'filter_block' => 'grid_empty_filter'),
												'Value' => Array ( 'title'=>'la_col_Value', 'data_block' => 'edit_custom_td', 'filter_block' => 'grid_empty_filter'),
												'OriginalValue'	=> Array ( 'title'=>'la_col_OriginalValue', 'data_block' => 'grid_original_td', 'filter_block' => 'grid_like_filter'),
											),
										),

								),
	);