<?php
/**
* @version	$Id: params.php 14241 2011-03-16 20:24:35Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class Params extends kBase {

		var $_Params = Array();

		function Params($params_str = null)
		{
			parent::kBase();
			if($params_str != '') $this->SplitParamsStr($params_str);
		}

		/**
		 * Splits tag params into associative array
		 *
		 * @param string $params_str
		 * @access private
		 */
		function SplitParamsStr($params_str)
		{
	//		$re = preg_quote('([\${}a-zA-Z0-9_.-#\[\]]+)=(["\']{1,1})(.*?)(?<!\\)\2','/');
	//		preg_match_all('/'.$re.'/s', $params_str, $rets, PREG_SET_ORDER);
			preg_match_all('/([\${}a-zA-Z0-9_.\\-\\\\#\\[\\]]+)=(["\']{1,1})(.*?)(?<!\\\)\\2/s', $params_str, $rets, PREG_SET_ORDER);

			$values = Array();
			foreach ($rets AS $key => $val){
				$values[$val[1]] = str_replace('\\' . $val[2], $val[2], $val[3]);
			}
			$this->AddParams($values);
		}

		/**
		 * Sets new parameter value
		 *
		 * @param string $name
		 * @param string $val
		 * @access public
		 */
		function Set($name, $val)
		{
			$this->_Params[$name] = $val;
		}

		/**
		 * Removes parameter
		 *
		 * @param string $name
		 * @access public
		 */
		function Remove($name)
		{
			unset($this->_Params[$name]);
		}

		/**
		 * Gets parameter value by parameter name
		 *
		 * @param string $name Name of variable to retrieve
		 * @param int $default default value returned in case if varible not present
		 * @return string
		 * @access public
		 */
		function Get($name, $default = false)
		{
			return isset($this->_Params[$name]) ? $this->_Params[$name] : $default;
		}

		/**
		 * Mass parameter setting from hash
		 *
		 * @param Array $params
		 * @access public
		 */
		function AddParams($params)
		{
			if (!is_array($params)) return;
			/*if (count($this->_Params) == 0) {
				$this->_Params = $params;
			}
			else {*/
				foreach ($params as $name => $val)
	//				$this->Set(strtolower($name), $val);
					$this->Set($name, $val);
			//}
		}

		/**
		 * Return all paramters as hash
		 *
		 * @return Array
		 * @access public
		 */
		function GetParams()
		{
			return $this->_Params;
		}
	}

	class kArray extends kBase {
		var $_Array;

		/**
		 * Returns array value with any deep key
		 *
		 * @return mixed
		 * @todo array_unshift doesn't accept parameters by reference, fix it's usage in this method
		 */
		function GetArrayValue()
		{
			$args = func_get_args();
			array_unshift_ref($args, $this->_Array);
			return call_user_func_array('getArrayValue', $args);
		}

		function SetArrayValue()
		{
			$args = func_get_args();
			$value = array_pop($args);

			$arr =& $this->_Array;
			for ($i=0; $i<count($args); $i++) {
				$key = $args[$i];
				if ( !isset($arr[$key]) || !is_array($arr[$key]) ) {
					$arr[$key] = Array();
				}
				$arr =& $arr[$key];
			}
			$arr = $value;
		}
	}