<?php
/**
* @version	$Id: form_submissions_config.php 14241 2011-03-16 20:24:35Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	$config =	Array(
					'Prefix'			=>	'formsubs',
					'ItemClass'			=>	Array('class'=>'kDBItem','file'=>'','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class'=>'FormSubmissionsEventHandler','file'=>'form_submissions_eh.php','build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class'=>'FormSubmissionTagProcessor', 'file' => 'form_submission_tp.php', 'build_event'=>'OnBuild'),
					'AutoLoad'			=>	true,
					'QueryString'		=>	Array(
												1 => 'id',
												2 => 'Page',
												3 => 'PerPage',
												4 => 'event',
												5 => 'mode',
											),

					'Hooks'				=>	Array(
											Array(
												'Mode' => hAFTER,
												'Conditional' => false,
												'HookToPrefix' => '',
												'HookToSpecial' => '*',
												'HookToEvent' => Array('OnAfterConfigRead'),
												'DoPrefix' => '',
												'DoSpecial' => '',
												'DoEvent' => 'OnBuildFormFields',
											),

											// Captcha processing
											Array (
												'Mode' => hAFTER,
												'Conditional' => false,
												'HookToPrefix' => '',
												'HookToSpecial' => '*',
												'HookToEvent' => Array('OnAfterConfigRead'),
												'DoPrefix' => 'captcha',
												'DoSpecial' => '*',
												'DoEvent' => 'OnPrepareCaptcha',
											),
										),

					'TitlePresets' => Array(
						'default' => Array(
							'new_status_labels'		=> Array('form'=>'!la_title_Adding_Form!'),
							'edit_status_labels'	=> Array('form'=>'!la_title_Editing_Form!'),
						),

						'formsubs_list' => Array (
							'prefixes' =>	Array('form', 'formsubs_List'),
							'format' =>	"!la_title_FormSubmissions! '#form_titlefield#'",
							'toolbar_buttons' => Array ('edit', 'delete', 'view', 'dbl-click'),
						),

						'formsubs_view' => Array(
							'prefixes' => Array('formsubs'),
							'format' => "!la_title_ViewingFormSubmission!",
							'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next'),
						),

						'submission_edit_logs' => Array (
							'prefixes' => Array ('formsubs', 'submission-log_List'),
							'format' => "!la_title_ViewingFormSubmission! - !la_title_Messages! (#submission-log_recordcount#)"
						),

						'submission_log_edit' => Array (
							'new_status_labels' => Array ('submission-log' => '!la_title_NewReply!'),
							'edit_status_labels' => Array ('submission-log' => '!la_title_ViewingReply!'),

							'prefixes' => Array ('submission-log'), 'format' => "!la_title_ViewingFormSubmission! - #submission-log_status#"
						),
					),

					'EditTabPresets' => Array (
						'Default' => Array (
							Array ('title' => 'la_tab_General', 't' => 'submissions/submission_view', 'priority' => 1),
							Array ('title' => 'la_tab_Messages', 't' => 'submissions/submission_edit_logs', 'priority' => 2),
						),
					),

					'PermSection'		=>	Array('main' => 'in-portal:submissions'),

					'IDField'			=>	'FormSubmissionId',
					/*'TitleField'		=>	'Name',*/
					'StatusField' => Array ('LogStatus'),
					'TableName'			=>	TABLE_PREFIX.'FormSubmissions',
					'ListSQLs'	=>	Array(
							''=>'	SELECT %1$s.* %2$s FROM %1$s',
						), // key - special, value - list select sql
					'ItemSQLs'	=>	Array(
								''=>'SELECT %1$s.* %2$s FROM %1$s',
						),

					/*'ForeignKey'	=>	'FormId',
					'ParentTableKey' => 'FormId',
					'ParentPrefix' => 'form',
					'AutoDelete'	=>	true,
					'AutoClone'	=> true,*/

					'SubItems' => Array ('submission-log', 'draft'),

					'ListSortings'	=> 	Array(
						'' => Array(
							'Sorting' => Array('SubmissionTime' => 'desc'),
						)
					),

					'Fields' => Array(
						'FormSubmissionId' => Array('type' => 'int', 'not_null' => 1,'default' => 0),
						'FormId' => Array('type' => 'int','not_null' => '1','default' => 0),
						'SubmissionTime' => Array('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#'),
						'IPAddress' => Array ('type' => 'string', 'max_len' => 15, 'not_null' => 1, 'default' => ''),
						'ReferrerURL' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),

						'LogStatus' => Array (
							'type' => 'int',
							'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_opt_Replied', 2 => 'la_opt_NotReplied', 3 => 'la_opt_NewEmail', 4 => 'la_opt_Bounce'), 'use_phrases' => 1,
							'not_null' => 1, 'required' => 1, 'default' => 2
						),

		    			'LastUpdatedOn' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => NULL),
		    			'Notes' => Array ('type' => 'string', 'default' => NULL),
		    			'MessageId' => Array ('type' => 'string', 'max_len' => 255, 'default' => NULL),
					),
					'VirtualFields'	=>	Array (
						'MergeToSubmission' => Array (
							'type' => 'int',
							'formatter' => 'kOptionsFormatter', 'options' => Array (),
							'default' => NULL
						),

						'IsMergeToSubmission' => Array (
							'type' => 'int',
							'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
							'default' => 0
						),
					),
					'CalculatedFields'	=>	Array(
					),
					'Grids'	=> Array(
						'Default'		=>	Array(
							'Icons' => Array('default' => 'icon16_item.png', 1 => 'icon16_replied.gif', 2 => 'icon16_not_replied.gif', 3 => 'icon16_new_email.gif', 4 => 'icon16_bounce.gif'),
							'Fields' => Array(
								'FormSubmissionId' => Array( 'title'=>'la_col_Id', 'data_block' => 'grid_checkbox_td', 'sort_field' => 'FormFieldId', 'filter_block' => 'grid_range_filter', 'width' => 60 ),
								'SubmissionTime' => Array( 'title'=>'la_prompt_SumbissionTime', 'filter_block' => 'grid_date_range_filter', 'width' => 145 ),
								'IPAddress' => Array ('title' => 'la_col_IPAddress', 'filter_block' => 'grid_like_filter', 'width' => 100 ),
      							'ReferrerURL' => Array ('title' => 'la_col_ReferrerURL', 'filter_block' => 'grid_like_filter', 'first_chars' => 100, 'width' => 200 ),
      							'LogStatus' => Array ('title' => 'la_col_Status', 'filter_block' => 'grid_options_filter', 'width' => 100 ),
								'LastUpdatedOn' => Array ('title' => 'la_col_LastUpdatedOn', 'filter_block' => 'grid_date_range_filter', 'width' => 145 ),
							),
						),
					),
	);