<?php
/**
* @version	$Id: reviews_tag_processor.php 13435 2010-04-27 10:27:11Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class ReviewsTagProcessor extends kDBTagProcessor
{
	/**
	 * Returns a link for editing product
	 *
	 * @param Array $params
	 * @return string
	 */
	function ItemEditLink($params)
	{
		$object =& $this->getObject();
		/* @var $object kDBList */

		$item_prefix = $this->Application->findModule('Name', $object->GetDBField('Module'), 'Var');
		$edit_template = $this->Application->getUnitOption($item_prefix, 'AdminTemplatePath') . '/' . $this->Application->getUnitOption($item_prefix, 'AdminTemplatePrefix') . 'edit';

		$url_params = Array (
			'm_opener'				=>	'd',
			$item_prefix.'_mode'	=>	't',
			$item_prefix.'_event'	=>	'OnEdit',
			$item_prefix.'_id'		=>	$object->GetDBField('CatalogItemId'),
			'm_cat_id'				=>	$object->GetDBField('CatalogItemCategory'),
			'pass'					=>	'all,'.$item_prefix,
			'no_pass_through'		=>	1,
		);

		return $this->Application->HREF($edit_template,'', $url_params);
	}

	/**
	 * Get's reuested field value
	 *
	 * @param Array $params
	 * @return string
	 * @access public
	 */
	function Field($params)
	{
		$field = $this->SelectParam($params, 'name,field');
		$object =& $this->Application->recallObject($this->getPrefixSpecial(),$this->Prefix, $params);

		if ($field == 'ReviewText') {
			if ($object->GetDBField('TextFormat') == 1) {
				$params['no_special'] = 'no_special';
			}
			else {
				unset($params['no_special']);
			}
		}

		return parent::Field($params);
	}

	function AlreadyReviewed($params)
	{
		$parent_prefix = $this->Application->getUnitOption($this->Prefix, 'ParentPrefix');
		$main_object =& $this->Application->recallObject($parent_prefix);
		/* @var $main_object kCatDBItem */

		$spam_helper =& $this->Application->recallObject('SpamHelper');
		/* @var $spam_helper SpamHelper */

		$spam_helper->InitHelper($main_object->GetDBField('ResourceId'), 'Review', 0, $main_object->GetCol('ResourceId'));

		return $spam_helper->InSpamControl();
	}

	function HasError($params)
	{
		$object =& $this->Application->recallObject($this->getPrefixSpecial(), $this->Prefix, $params);
		if (method_exists($object, 'GetErrorMsg')) {
			return parent::HasError($params);
		}
		else {
			return 0;
		}
	}

	/**
	 * Preserve main item id in subitem pagination url
	 *
	 * @param Array $params
	 * @return string
	 */
	function PageLink($params)
	{
		$object =& $this->getObject($params);
		/* @var kDBList */

		$parent_info = $object->getLinkedInfo();
		if ($parent_info['ParentId'] > 0) {
			$params['pass'] = 'm,'.$this->getPrefixSpecial().','.$parent_info['ParentPrefix'];
		}
		return parent::PageLink($params);
	}

	function InitCatalogTab($params)
	{
		$tab_params['mode'] = $this->Application->GetVar('tm'); // single/multi selection possible
		$tab_params['special'] = $this->Application->GetVar('ts'); // use special for this tab
		$tab_params['dependant'] = $this->Application->GetVar('td'); // is grid dependant on categories grid

		// set default params (same as in catalog)
		if ($tab_params['mode'] === false) $tab_params['mode'] = 'multi';
		if ($tab_params['special'] === false) $tab_params['special'] = '';
		if ($tab_params['dependant'] === false) $tab_params['dependant'] = 'yes';

		// pass params to block with tab content
		$params['name'] = $params['render_as'];
		$params['prefix'] = trim($this->Prefix.'.'.($tab_params['special'] ? $tab_params['special'] : $this->Special), '.');

		$params['cat_prefix'] = trim('c.'.($tab_params['special'] ? $tab_params['special'] : $this->Special), '.');
		$params['tab_mode'] = $tab_params['mode'];
		$params['grid_name'] = ($tab_params['mode'] == 'multi') ? $params['default_grid'] : $params['radio_grid'];
		$params['tab_dependant'] = $tab_params['dependant'];
		$params['show_category'] = $tab_params['special'] == 'showall' ? 1 : 0; // this is advanced view -> show category name
		$params['tab_name'] = $this->Application->GetVar('tab_name');

		return $this->Application->ParseBlock($params, 1);
	}

	/**
	 * Returns reviews count for each item type (in "Reviews" section)
	 *
	 * @param Array $params
	 * @return string
	 */
	function CatalogItemCount($params)
	{
		$params['skip_quering'] = true;
		$object =& $this->GetList($params);

		if (!$object->Counted) {
			$object->CountRecs();
		}

		return $object->NoFilterCount != $object->RecordsCount ? $object->RecordsCount.' / '.$object->NoFilterCount : $object->RecordsCount;
	}
}