<?php
/**
* @version	$Id: change_logs_config.php 14161 2011-01-11 10:37:58Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'change-log',
		'ItemClass' => Array('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'ChangeLogEventHandler', 'file' => 'change_log_eh.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'kDBTagProcessor', 'file' => '', 'build_event' => 'OnBuild'),

		'RegisterClasses' => Array (
			Array ('pseudo' => 'kChangesFormatter', 'class' => 'kChangesFormatter', 'file' => 'changes_formatter.php', 'build_event' => '', 'require_classes' => 'kFormatter'),
		),

		'AutoLoad' => true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'PerPage',
			4 => 'event',
			5 => 'mode',
		),

		'IDField' => 'ChangeLogId',
		//'StatusField' => Array ('Status'),
		'TableName' => TABLE_PREFIX.'ChangeLogs',

		'TitlePresets' => Array (
			'default' => Array (				
				'edit_status_labels' => Array ('change-log' => '!la_title_EditingChangeLog!'),
			),

			'change_log_list' => Array (
				'prefixes' => Array('change-log_List'), 'format' => '!la_tab_ChangeLog!',
				'toolbar_buttons' => Array ('edit', 'delete', 'view'),
			),

			'change_log_edit' => Array (
				'prefixes' => Array('change-log'), 'format' => '#change-log_status# #change-log_titlefield#',
				'toolbar_buttons' => Array ('select', 'cancel', 'reset_edit', 'prev', 'next'),
			),
		),

		'PermSection' => Array ('main' => 'in-portal:change_logs'),

		// don't forget to add corresponding permissions to install script
		// INSERT INTO Permissions VALUES (0, 'in-portal:change_logs.view', 11, 1, 1, 0), (0, 'in-portal:change_logs.add', 11, 1, 1, 0), (0, 'in-portal:change_logs.edit', 11, 1, 1, 0), (0, 'in-portal:change_logs.delete', 11, 1, 1, 0);
		'Sections' => Array (
			'in-portal:change_logs' => Array (
				'parent'		=>	'in-portal:reports',
				'icon'			=>	'changes_log', // 'change_logs',
				'label'			=>	'la_tab_ChangeLog',
				'url'			=>	Array('t' => 'logs/change_logs/change_log_list', 'pass' => 'm'),
				'permissions'	=>	Array('view', 'edit', 'delete'),
				'priority'		=>	3,
//				'show_mode'		=>	smSUPER_ADMIN,
				'type'			=>	stTREE,
			),
		),

		'TitleField' => 'ChangeLogId',

		'ListSQLs' => Array (
			'' => '	SELECT %1$s.* %2$s
					FROM %1$s
					LEFT JOIN '.TABLE_PREFIX.'PortalUser AS u ON u.PortalUserId = %1$s.PortalUserId',
		),

		'ListSortings' => Array (
			'' => Array (
				'Sorting' => Array ('OccuredOn' => 'desc'),
			)
		),

		'CalculatedFields' => Array (
			'' => Array (
				'UserLogin' => 'IF(%1$s.PortalUserId = ' . USER_ROOT . ', \'root\', u.Login)',
				'UserFirstName' => 'u.FirstName',
				'UserLastName' => 'u.LastName',
				'UserEmail' => 'u.Email',
			),
		),

		'ForceDontLogChanges' => true,

		'Fields' => Array (
		    'ChangeLogId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'PortalUserId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'SessionLogId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'Action' => Array (
		    	'type' => 'int', 'formatter' => 'kOptionsFormatter',
		    	'options' => array (clCREATE => 'la_opt_ActionCreate', clUPDATE => 'la_opt_ActionUpdate', clDELETE => 'la_opt_ActionDelete'),
		    	'use_phrases' => 1,
		    	'not_null' => 1, 'default' => 0
		    ),
		    'OccuredOn' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'time_format' => 'H:i:s', 'default' => NULL),
		    'Prefix' => Array (
		    	'type' => 'string', 'formatter' => 'kOptionsFormatter',
		    	'options_sql' => 'SELECT DISTINCT %s FROM '.TABLE_PREFIX.'ChangeLogs ORDER BY Phrase',
		    	'option_key_field' => 'Prefix',
		    	'option_title_field' => 'CONCAT(\'la_prefix_\', Prefix) AS Phrase',
		    	'use_phrases' => 1,
		    	'max_len' => 255, 'not_null' => 1, 'default' => ''
		    ),
		    'ItemId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'Changes' => Array ('type' => 'string', 'formatter' => 'kChangesFormatter', 'default' => NULL),
		    'MasterPrefix' => Array (
		    	'type' => 'string', 'formatter' => 'kOptionsFormatter',
		    	'options_sql' => 'SELECT DISTINCT %s FROM '.TABLE_PREFIX.'ChangeLogs ORDER BY Phrase',
		    	'option_key_field' => 'MasterPrefix',
		    	'option_title_field' => 'CONCAT(\'la_prefix_\',MasterPrefix) AS Phrase',
		    	'use_phrases' => 1,
		    	'max_len' => 255, 'not_null' => 1, 'default' => ''
		    ),
		    'MasterId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		),

		'VirtualFields' => Array (
			'UserLogin' => Array ('type' => 'string', 'default' => ''),
			'UserFirstName' => Array ('type' => 'string', 'default' => ''),
			'UserLastName' => Array ('type' => 'string', 'default' => ''),
			'UserEmail' => Array ('type' => 'string', 'default' => ''),
		),

		'Grids' => Array (
			'Default' => Array (
				'Icons' => Array ('default' => 'icon16_item.png'),
				'Fields' => Array (
					'ChangeLogId' => Array ('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 70, ),
					'PortalUserId' => Array ('title' => 'la_col_PortalUserId', 'filter_block' => 'grid_like_filter', 'width' => 70, ),
					'UserLogin' => Array ('title' => 'la_col_Username', 'filter_block' => 'grid_like_filter', 'width' => 100, ),
					'UserFirstName' => Array ('title' => 'la_col_FirstName', 'filter_block' => 'grid_like_filter', 'width' => 120, ),
					'UserLastName' => Array ('title' => 'la_col_LastName', 'filter_block' => 'grid_like_filter', 'width' => 120, ),
					'UserEmail' => Array ('title' => 'la_col_Email', 'filter_block' => 'grid_like_filter', 'width' => 120, ),
					'SessionLogId' => Array ('title' => 'la_col_SessionLogId', 'filter_block' => 'grid_range_filter', 'width' => 120, ),
					'Action' => Array ('title' => 'la_col_Action', 'filter_block' => 'grid_options_filter', 'width' => 120, ),
					'OccuredOn' => Array ('title' => 'la_col_OccuredOn', 'filter_block' => 'grid_date_range_filter', 'width' => 150, ),
					'MasterPrefix' => Array ('title' => 'la_col_MasterPrefix', 'filter_block' => 'grid_options_filter', 'width' => 120,  ),
					'MasterId' => Array ('title' => 'la_col_MasterId', 'filter_block' => 'grid_range_filter', 'width' => 90, ),
					'Prefix' => Array ('title' => 'la_col_ItemPrefix', 'filter_block' => 'grid_options_filter', 'width' => 120,  ),
					'ItemId' => Array ('title' => 'la_col_ItemId', 'filter_block' => 'grid_range_filter', 'width' => 120, ),
					'Changes' => Array ('title' => 'la_col_Changes', 'data_block' => 'grid_changes_td', 'filter_block' => 'grid_like_filter', 'format' => 'auto_cut', 'width' => 225, ),
				),
			),
		),
	);