<?php
/**
* @version	$Id: group_tp.php 13086 2010-01-12 19:47:40Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class GroupTagProcessor extends kDBTagProcessor {

		/**
		 * Hides permission tab, when it's not allowed by configuration settings
		 *
		 * @param Array $params
		 */
		function ModifyUnitConfig($params)
		{
			$edit_tab_presets = $this->Application->getUnitOption($this->Prefix, 'EditTabPresets');

			$event = new kEvent($this->getPrefixSpecial() . ':OnItemBuild');
			$permission = $event->getSection() . '.advanced:manage_permissions';
			if (!$this->Application->CheckPermission($permission)) {
				unset($edit_tab_presets['Default']['permissions']);
			}

			$this->Application->setUnitOption($this->Prefix, 'EditTabPresets', $edit_tab_presets);
		}
	}