<?php
/**
* @version	$Id: forms_config.php 14161 2011-01-11 10:37:58Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config =	Array(
					'Prefix'			=>	'form',
					'ItemClass'			=>	Array('class'=>'kDBItem','file'=>'','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class'=>'FormsEventHandler','file'=>'forms_eh.php','build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class'=>'FormsTagProcessor','file'=>'forms_tp.php','build_event'=>'OnBuild'),

					'AutoLoad'			=>	true,
					'QueryString'		=>	Array(
												1 => 'id',
												2 => 'Page',
												3 => 'PerPage',
												4 => 'event',
												5 => 'mode',
											),

					'RegularEvents' => Array (
						'check_submission_repies' => Array('EventName' => 'OnProcessReplies', 'RunInterval' => 3600, 'Type' => reAFTER),
						'check_bounced_submission_repies' => Array('EventName' => 'OnProcessBouncedReplies', 'RunInterval' => 18000, 'Type' => reAFTER),
					),

					'Hooks'				=>	Array(
											Array(
												'Mode' => hAFTER,
												'Conditional' => false,
												'HookToPrefix' => 'form', //self
												'HookToSpecial' => '*',
												'HookToEvent' => Array('OnAfterConfigRead'),
												'DoPrefix' => '',
												'DoSpecial' => '',
												'DoEvent' => 'OnCreateSubmissionNodes',
											),
										),

					'TableName'			=>	TABLE_PREFIX.'Forms',
					'IDField'			=>	'FormId',
					'TitleField'	=>	'Title',
					'PermSection'		=>	Array('main' => 'in-portal:forms'),
					'Sections'			=>	Array(
						'in-portal:forms'	=>	Array(
							'parent'		=>	'in-portal:site',
							'icon'			=>	'form',
							'use_parent_header' => 1,
							'label'			=>	'la_tab_CMSForms', //'la_tab_FormsConfig',
							'url'			=>	Array('t' => 'forms/forms_list', 'pass' => 'm'), // set "container" parameter (in section definition, not url) to true when form editing should be disabled, but submissions still visible
							'permissions'	=>	Array('view', 'add', 'edit', 'delete'),
							'priority'		=>	6,
//							'show_mode'		=>	smSUPER_ADMIN,
							'type'			=>	stTREE,
						),
											),
					'TitlePresets'		=>	Array(
						'default'	=>	Array(	'new_status_labels'		=> Array('form'=>'!la_title_Adding_Form!'),
												'edit_status_labels'	=> Array('form'=>'!la_title_Editing_Form!'),
												'new_titlefield'		=> Array('form'=>''),
										),

						'forms_list' => Array (
									'prefixes' => Array ('form_List'),
									'format' =>	"!la_title_Forms!",
									'toolbar_buttons' => Array('new_item', 'edit', 'delete', 'view', 'dbl-click'),
								),

						'forms_edit' => Array (
									'prefixes' => Array('form'),
									'format' => "#form_status# '#form_titlefield#' - !la_title_General!",
									'toolbar_buttons' => Array('select', 'cancel', 'prev', 'next'),
								),

						'forms_edit_fields' => Array (
									'prefixes' => Array('form'),
									'format' => "#form_status# '#form_titlefield#' - !la_title_Fields!",
									'toolbar_buttons' => Array('select', 'cancel', 'prev', 'next', 'new_item', 'edit', 'delete', 'move_up', 'move_down', 'view', 'dbl-click'),
								),

						'form_edit_emails' => Array (
									'prefixes' => Array('form'),
									'format' => "#form_status# '#form_titlefield#' - !la_title_EmailCommunication!",
									'toolbar_buttons' => Array('select', 'cancel', 'prev', 'next'),
								),

						'form_field_edit' => Array (
									'prefixes' => Array('form', 'formflds'),
									'new_status_labels' => Array('formflds'=>"!la_title_Adding_FormField!"),
									'edit_status_labels' => Array('formflds'=>'!la_title_Editing_FormField!'),
									'new_titlefield' => Array('formflds'=>''),
									'format' => "#form_status# '#form_titlefield#' - #formflds_status# '#formflds_titlefield#'",
									'toolbar_buttons' => Array('select', 'cancel', 'prev', 'next'),
								),

						'tree_submissions' => Array (
									'format' =>	"!la_title_FormSubmissions!",
								),
					),

					'EditTabPresets' => Array (
						'Default' => Array (
							'general' => Array ('title' => 'la_tab_General', 't' => 'forms/forms_edit', 'priority' => 1),
							'fields' => Array ('title' => 'la_tab_Fields', 't' => 'forms/forms_edit_fields', 'priority' => 2),
							'emails' => Array ('title' => 'la_tab_EmailCommunication', 't' => 'forms/form_edit_emails', 'priority' => 3),
						),
					),

					'ListSQLs'	=>	Array(
							''=>'	SELECT %1$s.* %2$s FROM %1$s',
						), // key - special, value - list select sql
					'ItemSQLs'	=>	Array(
								''=>'SELECT %1$s.* %2$s FROM %1$s',
						),

					'SubItems'	=> Array('formflds'),

					'ListSortings'	=> 	Array(
						'' => Array(
							'Sorting' => Array('Title' => 'asc'),
						)
					),

					'Fields' => Array(
							'FormId' => Array('type' => 'int', 'not_null' => 1, 'default' => 0, 'filter_type' => 'equals'),
							'Title' => Array('type' => 'string','not_null' => 1, 'default' => '','required' => 1),
							'Description' => Array('type' => 'string', 'formatter' => 'kFormatter', 'using_fck' => 1, 'default' => null),
							'RequireLogin' => Array (
								'type' => 'int',
								'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
								'not_null' => 1, 'default' => 0
							),
    						'UseSecurityImage' => Array (
								'type' => 'int',
								'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
								'not_null' => 1, 'default' => 0
							),
							'EnableEmailCommunication' => Array (
								'type' => 'int',
								'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
								'not_null' => 1, 'default' => 0
							),
							'ProcessUnmatchedEmails' => Array (
								'type' => 'int',
								'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
								'not_null' => 1, 'default' => 0
							),
							'ReplyFromName' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
							'ReplyFromEmail' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
							'ReplyCc' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
							'ReplyBcc' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
							'ReplyMessageSignature' => Array ('type' => 'string', 'default' => NULL),
							'ReplyServer' => Array (
								'type' => 'string', 'max_len' => 255,
								'error_msgs' => Array (
									'connection_failed' => '!la_error_ConnectionFailed!',
									'message_listing_failed' => '!la_error_MessagesListReceivingFailed!',
								),
								'not_null' => 1, 'default' => ''
							),
							'ReplyPort' => Array ('type' => 'int', 'not_null' => 1, 'default' => 110),
							'ReplyUsername' => Array (
								'type' => 'string', 'max_len' => 255,
								'error_msgs' => Array (
									'login_failed' => '!la_error_LoginFailed!',
								),
								'not_null' => 1, 'default' => ''
							),
							'ReplyPassword' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
							'BounceEmail' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
							'BounceServer' => Array (
								'type' => 'string', 'max_len' => 255,
								'error_msgs' => Array (
									'connection_failed' => '!la_error_ConnectionFailed!',
									'message_listing_failed' => '!la_error_MessageListingFailed!',
								),
								'not_null' => 1, 'default' => ''
							),
							'BouncePort' => Array ('type' => 'int', 'not_null' => 1, 'default' => 110),
							'BounceUsername' => Array (
								'type' => 'string', 'max_len' => 255,
								'error_msgs' => Array (
									'login_failed' => '!la_error_LoginFailed!',
								),
								'not_null' => 1, 'default' => ''
							),
							'BouncePassword' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
					),
					'Grids'	=> Array(
						'Default'		=>	Array(
							'Icons' => Array(
								'default' => 'icon16_item.png',
								0 => 'icon16_disabled.png',
								1 => 'icon16_item.png',
								2 => 'icon16_pending.png',
							),
							'Fields' => Array(
								'FormId' => Array( 'title'=>'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
								'Title'	=> Array( 'title' => 'la_col_Title', 'filter_block' => 'grid_like_filter', 'width' => 220, ),
								'Description'	=> Array( 'title' => 'la_col_Description', 'filter_block' => 'grid_like_filter', 'width' => 300, ),
								'RequireLogin' => Array ('title' => 'la_col_RequireLogin', 'filter_block' => 'grid_options_filter', 'width' => 80,),
      							'UseSecurityImage' => Array ('title' => 'la_col_UseSecurityImage', 'filter_block' => 'grid_options_filter', 'width' => 110,),
      							'EnableEmailCommunication' => Array ('title' => 'la_col_EnableEmailCommunication', 'filter_block' => 'grid_options_filter', 'width' => 120,),
							),
						),
					),
		);