<?php
/**
* @version	$Id: category_items_tag_processor.php 13789 2010-06-15 21:00:24Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class CategoryItemsTagProcessor extends kDBTagProcessor
	{
		function CategoryName($params)
		{
			$field = $this->SelectParam($params, 'name,field');

			$object =& $this->getObject($params);
			/* @var $object kDBList */

			$root_phrase = $this->Application->Phrase(($this->Application->isAdmin ? 'la_' : 'lu_') . 'rootcategory_name');
			$cached_navbar = preg_replace('/^(Content&\|&|Content)/i', '', $object->GetDBField($field));
			$value = str_replace('&|&', ' > ', $cached_navbar);

			$ret = $root_phrase . ($value ? ' > ' : '') . $value;
			if ($object->GetDBField('PrimaryCat')) {
				$label = $params['primary_title'];
				$ret .= ' (' . $this->Application->Phrase($label) . ')';
			}

			return $ret;
		}

		function GetMainID()
		{
			$object =& $this->Application->recallObject( $this->getPrefixSpecial() );
			$table_info = $object->getLinkedInfo();
			return $table_info['ParentId'];
		}
	}