<?php

	class EmailEventTagProcessor extends kDBTagProcessor
	{
		/**
		 * Removes "Enabled" column, when not in debug mode
		 *
		 * @param Array $params
		 */
		function ModifyUnitConfig($params)
		{
			if (!$this->Application->isDebugMode()) {
				$grids = $this->Application->getUnitOption($this->Prefix, 'Grids');

				foreach ($grids as $grid_name => $grid_data) {
					if (array_key_exists('Enabled', $grid_data['Fields'])) {
						unset($grids[$grid_name]['Fields']['Enabled']);
					}
				}

				$this->Application->setUnitOption($this->Prefix, 'Grids', $grids);
			}
		}

		/**
		 * Checks, that field can be edited
		 *
		 * @param Array $params
		 * @return string
		 */
		function IsEditable($params)
		{
			if ($this->Application->isDebugMode()) {
				return true;
			}

			$object =& $this->getObject($params);
			/* @var $object kDBItem */

			return $object->GetDBField($params['check_field']);
		}

		/**
		 * Removes "To" options from possible options in "RecipientType" field
		 *
		 * @param Array $params
		 */
		function RemoveToRecipientType($params)
		{
			$object =& $this->getObject($params);
			/* @var $object kDBItem */

			$field_options = $object->GetFieldOptions('RecipientType');
			unset($field_options['options'][RECIPIENT_TYPE_TO]);
			$object->SetFieldOptions('RecipientType', $field_options);
		}

		/**
		 * Restores "To" option in possible option list in "RecipientType" field
		 *
		 * @param Array $params
		 */
		function RestoreRecipientType($params)
		{
			$object =& $this->getObject($params);
			/* @var $object kDBItem */

			$field_options = $object->GetFieldOptions('RecipientType');
			$virtual_fields = $this->Application->getUnitOption($this->Prefix, 'VirtualFields');
			$field_options['options'] = $virtual_fields['RecipientType']['options'];
			$object->SetFieldOptions('RecipientType', $field_options);
		}

	}