<?php
/**
* @version	$Id: constants.php 13951 2010-09-15 07:24:26Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	// kDBList filter types (then, types are divided into classes)
	define('HAVING_FILTER', 1);
	define('WHERE_FILTER', 2);
	define('AGGREGATE_FILTER', 3);

	// kDBList filter classes
	define('FLT_SYSTEM',	1);	// System Having/Where filter [AND]
	define('FLT_NORMAL',	2);	// User Having/Where filter [OR]
	define('FLT_SEARCH',	3);	// User "Search" Having/Where filter [OR]
	define('FLT_VIEW',		4);	// User "View Menu" Having/Where filter [AND]
	define('FLT_CUSTOM',	5); // Custom fields (above) grid columns [AND]

	// kMultipleFilter types
	define('FLT_TYPE_AND',	'AND');
	define('FLT_TYPE_OR',	'OR');

	// item statuses
	define('STATUS_DISABLED', 0);
	define('STATUS_ACTIVE', 1);
	define('STATUS_PENDING', 2);
	define('STATUS_PENDING_EDITING', -2);

	// sections
	define('stTREE', 1);
	define('stTAB', 2);

	// event statuses
	define('erSUCCESS',		0);		// event finished working succsessfully
	define('erFAIL',		-1);	// event finished working, but result is unsuccsessfull
	define('erFATAL',		-2);	// event experienced FATAL error - no hooks should continue!
	define('erPERM_FAIL',	-3);	// event failed on internal permission checking (user has not permission)
	define('erSTOP',		-4);	// event requested to stop processing (don't parse templates)

	// permission types
	define('ptCATEGORY', 	0);
	define('ptSYSTEM', 		1);

	// email event types
	define('EVENT_TYPE_FRONTEND', 0);
	define('EVENT_TYPE_ADMIN', 1);

	define('EDIT_MARK', '&|edit|&'); // replace this sequence inside filters to SID[_main_wid]

	$application =& kApplication::Instance();
	$spacer_url = $application->BaseURL().'core/admin_templates/img/spacer.gif';
	define('SPACER_URL', $spacer_url);

	if (!$application->isAdmin) {
		// don't show debugger buttons on front (if not overrided in "debug.php")
		safeDefine('DBG_TOOLBAR_BUTTONS', 0);
	}

	define('smHIDE', 0); // always hide section from tree
	define('smNORMAL', 1); // show section even, if they were marked as smDEBUG or smSUPER_ADMIN before
	define('smDEBUG', 2); // show section in debug mode only
	define('smSUPER_ADMIN', 4); // show section in super admin & debug mode

	// common usage regular expressions
	define('REGEX_EMAIL_USER', '[-a-zA-Z0-9!\#$%&*+\/=?^_`{|}~.]+');
	define('REGEX_EMAIL_DOMAIN', '[a-zA-Z0-9]{1}[-.a-zA-Z0-9_]*\.[a-zA-Z]{2,6}');
	define('ALLOW_DEFAULT_SETTINGS', '_USE_DEFAULT_USER_DATA_'); //Allow persistent vars to take data from default user's persistent data

	define('XML_NO_TEXT_NODES', 1); // Normal mode for XMLHelper
	define('XML_WITH_TEXT_NODES', 2); // Will create text nodes for every char-data (used in kPDFHelper)

	// ChangeLog actions
	define('clCREATE', 1);
	define('clUPDATE', 2);
	define('clDELETE', 3);

	// Separator for ValueList fields
	define('VALUE_LIST_SEPARATOR', '||');

	// template editing modes
	define('EDITING_MODE_BROWSE', 1); // no changes, front-end as users see it
	define('EDITING_MODE_CONTENT', 2); // content blocks + phrase editing
	define('EDITING_MODE_DESIGN', 3); // all other blocks

	// agent types
	define('AGENT_TYPE_USER', 1);
	define('AGENT_TYPE_SYSTEM', 2);

	// agent last run statuses
	define('AGENT_LAST_RUN_SUCCEDED', 1);
	define('AGENT_LAST_RUN_FAILED', 0);
	define('AGENT_LAST_RUN_RUNNING', 2);

	// place for product file uploads (sort of "/system/images" but for all other files)
	define('ITEM_FILES_PATH', WRITEBALE_BASE . '/downloads/');

	// mailing list statuses
	define('MAILING_LIST_NOT_PROCESSED', 1);
	define('MAILING_LIST_PARTIALLY_PROCESSED', 2);
	define('MAILING_LIST_PROCESSED', 3);
	define('MAILING_LIST_CANCELLED', 4);

	// theme file statuses (related to structure creation process)
	define('SMS_MODE_AUTO', 1);
	define('SMS_MODE_FORCE', 2);

	// Means, that actual category Template field value should inherited from parent category
	define('CATEGORY_TEMPLATE_INHERIT', '#inherit#');

	define('REWRITE_MODE_BUILD', 1);
	define('REWRITE_MODE_PARSE', 2);

	define('SESSION_LOG_ACTIVE', 0);
	define('SESSION_LOG_LOGGED_OUT', 1);
	define('SESSION_LOG_EXPIRED', 2);

	define('LOGIN_RESULT_OK', 0);
	define('LOGIN_RESULT_INVALID_LOGIN', 1);
	define('LOGIN_RESULT_INVALID_PASSWORD', 2);
	define('LOGIN_RESULT_BANNED', 3);
	define('LOGIN_RESULT_NO_PERMISSION', 4);

	define('DESTINATION_TYPE_COUNTRY', 1);
	define('DESTINATION_TYPE_STATE', 2);

	// form field visibility
	define('FORM_FIELD_EVERYONE', 1);
	define('FORM_FIELD_UNREGISTERED', 2);

	// form field e-mail communication roles
	define('EMAIL_COMMUNICATION_ROLE_NAME', 1);
	define('EMAIL_COMMUNICATION_ROLE_EMAIL', 2);
	define('EMAIL_COMMUNICATION_ROLE_SUBJECT', 3);
	define('EMAIL_COMMUNICATION_ROLE_BODY', 4);

	// form submission statuses
	define('SUBMISSION_REPLIED', 1);		// submission was replied by admin
	define('SUBMISSION_NOT_REPLIED', 2);	// submission has no client replies (no messages at all)
	define('SUBMISSION_NEW_EMAIL', 3);		// submission have new reply/email from client
	define('SUBMISSION_BOUNCE', 4);			// submission have bounce from client

	// submission log statuses
	define('SUBMISSION_LOG_SENT', 1);
	define('SUBMISSION_LOG_BOUNCE', 2);
	define('SUBMISSION_LOG_REPLIED', 1);

	define('SUBMISSION_LOG_ATTACHMENT_PATH', WRITEBALE_BASE . '/user_files/submission_log/');

	define('TIMENOW', adodb_mktime()); // for faster message processing

	// site domains
	define('SITE_DOMAIN_REDIRECT_CURRENT', 1);
	define('SITE_DOMAIN_REDIRECT_EXTERNAL', 2);

	define ('KG_TO_POUND', 2.20462262);
	define ('POUND_TO_KG', 0.45359237);

	// email event address types
	define('ADDRESS_TYPE_EMAIL', 1);
	define('ADDRESS_TYPE_USER', 2);
	define('ADDRESS_TYPE_GROUP', 3);

	define('RECIPIENT_TYPE_TO', 1);
	define('RECIPIENT_TYPE_CC', 2);
	define('RECIPIENT_TYPE_BCC', 3);

	define('PAGE_TYPE_VIRTUAL', 1);
	define('PAGE_TYPE_TEMPLATE', 2);