<?php
/**
* @version	$Id: users_item.php 13086 2010-01-12 19:47:40Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class UsersItem extends kDBItem {

		/**
		 * Returns IDs of groups to which user belongs and membership is not expired
		 *
		 * @return Array
		 * @access public
		 */
		function getMembershipGroups($force_reload = false)
		{
			$user_groups = $this->Application->RecallVar('UserGroups');
			if($user_groups === false || $force_reload)
			{
				$sql = 'SELECT GroupId FROM %s WHERE (PortalUserId = %s) AND ( (MembershipExpires IS NULL) OR ( MembershipExpires >= UNIX_TIMESTAMP() ) )';
				$sql = sprintf($sql, TABLE_PREFIX.'UserGroup', $this->GetID() );
				return $this->Conn->GetCol($sql);
			}
			else
			{
				return explode(',', $user_groups);
			}
		}

		/**
		 * Set's Login from Email if required by configuration settings
		 *
		 */
		function setLogin()
		{
			if( $this->Application->ConfigValue('Email_As_Login') )
			{
				$this->SetDBField('Login', $this->GetDBField('Email') );
			}
		}

		function SendEmailEvents()
		{
			switch ($this->GetDBField('Status')) {
				case STATUS_ACTIVE:
					$event_name = $this->Application->ConfigValue('User_Password_Auto') ? 'USER.VALIDATE' : 'USER.ADD';
					$this->Application->EmailEventAdmin($event_name);
					$this->Application->EmailEventUser($event_name, $this->GetID());
					break;

				case STATUS_PENDING:
					$this->Application->EmailEventAdmin('USER.ADD.PENDING');
					$this->Application->EmailEventUser('USER.ADD.PENDING', $this->GetID());
					break;
			}
		}

		function isSubscriberOnly()
		{
			$subscribers_group_id = $this->Application->ConfigValue('User_SubscriberGroup');
			$sql = 'SELECT PortalUserId
					FROM '.TABLE_PREFIX.'UserGroup
					WHERE 	GroupId = '.$subscribers_group_id.' AND
							PortalUserId = '.$this->GetDBField('PortalUserId').' AND
							PrimaryGroup = 1';
			return $this->Conn->GetOne($sql) == $this->GetDBField('PortalUserId');
		}

		function Create($force_id=false, $system_create=false)
		{
			$ret = parent::Create($force_id, $system_create);
			if ($ret) {
				// find out how to syncronize user only when it's copied to live table
				$sync_manager =& $this->Application->recallObjectP('UsersSyncronizeManager', null, Array(), 'InPortalSyncronize');
				$sync_manager->performAction('createUser', $this->FieldValues);
			}
			return $ret;
		}


		function Update($id=null, $system_update=false)
		{
			$ret = parent::Update($id, $system_update);
			if ($ret) {
				// find out how to syncronize user only when it's copied to live table
				$sync_manager =& $this->Application->recallObjectP('UsersSyncronizeManager', null, Array(), 'InPortalSyncronize');
				$sync_manager->performAction('updateUser', $this->FieldValues);
			}
			return $ret;
		}

		/**
		* Deletes the record from databse
		*
		* @access public
		* @return bool
		*/
		function Delete($id = null)
		{
			$ret = parent::Delete($id);
			if ($ret) {
				$sync_manager =& $this->Application->recallObjectP('UsersSyncronizeManager', null, Array(), 'InPortalSyncronize');
				$sync_manager->performAction('deleteUser', $this->FieldValues);
			}

			return $ret;
		}

		function setName($full_name)
		{
			$full_name = explode(' ', $full_name);

			if (count($full_name) > 2) {
				$last_name = array_pop($full_name);
				$first_name = implode(' ', $full_name);
			}
			else {
				$last_name = $full_name[1];
				$first_name = $full_name[0];
			}

			$this->SetDBField('FirstName', $first_name);
			$this->SetDBField('LastName', $last_name);
		}

	}