<?php
/**
* @version	$Id: ban_rules_config.php 13159 2010-02-24 10:45:00Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/
defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'ban-rule',
		'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'kDBEventHandler', 'file' => '', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'kDBTagProcessor', 'file' => '', 'build_event' => 'OnBuild'),

		'AutoLoad' => true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'PerPage',
			4 => 'event',
			5 => 'mode',
		),

		'IDField' => 'RuleId',

		'TableName' => TABLE_PREFIX.'BanRules',

		'StatusField' => Array ('Status'),

		'TitleField' => 'ItemValue',

		'TitlePresets' => Array (
			'default' => Array (
				'new_status_labels' => Array ('ban-rule' => '!la_title_AddingBanRule!'),
				'edit_status_labels' => Array ('ban-rule' => '!la_title_EditingBanRule!'),
			),

			'ban_rule_list' => Array (
					'prefixes' => Array ('ban-rule_List'), 'format' => "!la_tab_BanList!",
					'toolbar_buttons' => Array ('new_item', 'edit', 'delete', 'approve', 'decline', 'view', 'dbl-click'),
				),

			'ban_rule_edit' => Array (
					'prefixes' => Array ('ban-rule'), 'format' => "#ban-rule_status# '#ban-rule_titlefield#'",
					'toolbar_buttons' => Array ('select', 'cancel', 'reset_edit', 'prev', 'next'),
				),
		),

		'PermSection' => Array('main' => 'in-portal:user_banlist'),

		'Sections' => Array (
			'in-portal:user_banlist' => Array (
				'parent'		=>	'in-portal:users',
				'icon'			=>	'banlist',
				'label'			=>	'la_tab_BanList',
				'url'			=>	Array('t' => 'ban_rules/ban_rule_list', 'pass' => 'm'),
				'permissions'	=>	Array ('view', 'add', 'edit', 'delete'),
				'priority'		=>	4,
				'type'			=>	stTREE,
			),
		),

		'ListSQLs' => Array (
			'' => '	SELECT %1$s.* %2$s FROM %1$s',
		),

		'ListSortings' => Array (
			'' => Array (
				'Sorting' => Array ('Priority' => 'desc'),
			)
		),

		'Fields' => Array (
			'RuleId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'RuleType' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0, 'use_phrases' => 1, 'formatter'=>'kOptionsFormatter', 'options'=>Array(
					0 => 'la_opt_Deny',
//					1 => 'la_opt_Allow'
				)
			),
			'ItemField' => Array ('type' => 'string', 'max_len' => 255, 'default' => NULL, 'use_phrases' => 1, 'formatter'=>'kOptionsFormatter', 'options' => Array(
					'ip' => 'la_opt_IP_Address',
					'Login' => 'la_opt_Username',
					'Email' => 'la_opt_Email',
					'FirstName' => 'la_opt_FirstName',
					'LastName' => 'la_opt_LastName',
					'Address' => 'la_opt_Address',
					'City' => 'la_opt_City',
					'State' => 'la_opt_State',
					'Zip' => 'la_opt_Zip',
					'Phone' => 'la_opt_Phone',
				)
			),
			'ItemVerb' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0, 'use_phrases' => 1, 'formatter'=>'kOptionsFormatter', 'options'=>Array(
					1 => 'la_opt_Exact',
					3 => 'la_opt_Sub-match'
				)
			),
			'ItemValue' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'required' => 1, 'default' => ''),
			'ItemType' => Array ('type' => 'int', 'not_null' => 1, 'default' => 6),
			'Priority' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'Status' => Array ('type' => 'int', 'not_null' => 1, 'default' => 1, 'use_phrases' => 1, 'formatter'=>'kOptionsFormatter', 'options'=>Array(
					1 => 'la_Enabled',
					0 => 'la_Disabled'
				)
			),
			'ErrorTag' => Array ('type' => 'string', 'max_len' => 255, 'default' => NULL),
		),

		'Grids' => Array (
			'Default' => Array (
				'Icons' => Array (
					'default' => 'icon16_item.png',
					0 => 'icon16_disabled.png',
					1 => 'icon16_item.png',
				),
				'Fields' => Array (
					'RuleId' => Array ('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 70, ),
					'RuleType' => Array ('title' => 'la_col_RuleType', 'filter_block' => 'grid_options_filter', 'width' => 100, ),
					'ItemField' => Array ('title' => 'la_col_ItemField', 'filter_block' => 'grid_options_filter', 'width' => 130, ),
					'ItemVerb' => Array ('title' => 'la_col_FieldComparision', 'filter_block' => 'grid_options_filter', 'width' => 100, ),
					'ItemValue' => Array ('title' => 'la_col_FieldValue', 'filter_block' => 'grid_like_filter', 'width' => 200, ),
					'Status' => Array ('title' => 'la_col_Status', 'filter_block' => 'grid_options_filter', 'width' => 90, ),
				),
			),
		),
	);