<?php
/**
* @version	$Id: languages_config.php 13545 2010-05-11 19:19:58Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config =	Array(
					'Prefix'			=>	'lang',
					'ItemClass'			=>	Array('class'=>'LanguagesItem','file'=>'languages_item.php','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class'=>'LanguagesEventHandler','file'=>'languages_event_handler.php','build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class'=>'LanguagesTagProcessor','file'=>'languages_tag_processor.php','build_event'=>'OnBuild'),

					'AutoLoad'			=>	true,
					'Hooks'	=>	Array(
						Array(
							'Mode' => hAFTER,
							'Conditional' => false,
							'HookToPrefix' => 'lang',
							'HookToSpecial' => '*',
							'HookToEvent' => Array('OnSave'),
							'DoPrefix' => '',
							'DoSpecial' => '',
							'DoEvent' => 'OnUpdatePrimary',
						),

						Array(
							'Mode' => hAFTER,
							'Conditional' => false,
							'HookToPrefix' => 'lang',
							'HookToSpecial' => '*',
							'HookToEvent' => Array('OnSave','OnMassDelete'),
							'DoPrefix' => '',
							'DoSpecial' => '',
							'DoEvent' => 'OnScheduleTopFrameReload',
						),

					),
					'QueryString'		=>	Array(
												1 => 'id',
												2 => 'Page',
												3 => 'PerPage',
												4 => 'event',
												5 => 'mode',
											),
					'IDField'			=>	'LanguageId',

					'StatusField'		=>	Array('Enabled','PrimaryLang'),	// field, that is affected by Approve/Decline events

					'TitleField'		=>	'PackName',		// field, used in bluebar when editing existing item

					'TitlePresets'		=>	Array(
												'default'	=>	Array(	'new_status_labels'		=> Array('lang'=>'!la_title_Adding_Language!'),
																		'edit_status_labels'	=> Array('lang'=>'!la_title_Editing_Language!'),
																		'new_titlefield'		=> Array('lang'=>''),
																),

												'languages_list'			=>	Array(
													'prefixes'	=>	Array('lang_List'), 'format' => "!la_title_Configuration! - !la_title_LanguagePacks!",
													'toolbar_buttons' => Array ('new_item', 'edit', 'delete', 'export', 'import', 'setprimary', 'refresh', 'view', 'dbl-click'),
												),

												'languages_edit_general'	=>	Array(	'prefixes'	=> Array('lang'), 'format' => "#lang_status# '#lang_titlefield#' - !la_title_General!"),

												'phrases_list'				=>	Array(	'prefixes'	=> Array('lang','phrases_List'), 'format' => "#lang_status# '#lang_titlefield#' - !la_title_Labels!"),

												'phrase_edit'				=>	Array (
													'prefixes' 				=>	Array('phrases'),
													'new_status_labels'		=> Array('phrases'=>'!la_title_Adding_Phrase!'),
													'edit_status_labels'	=>	Array('phrases'	=>	'!la_title_Editing_Phrase!'),
													'format' 				=> 	"#phrases_status# '#phrases_titlefield#'"
												),

												'import_language'			=>	Array(	'prefixes'	=> Array('phrases.import'), 'format' => "!la_title_InstallLanguagePackStep1!"),

												'import_language_step2'		=>	Array(	'prefixes'	=> Array('phrases.import'), 'format' => "!la_title_InstallLanguagePackStep2!"),

												'export_language'			=>	Array(	'prefixes'	=> Array('phrases.export'), 'format' => "!la_title_ExportLanguagePackStep1!"),

												'export_language_results'	=>	Array(	'prefixes'	=> Array(), 'format' => "!la_title_ExportLanguagePackResults!"),

												'events_list'				=>	Array(	'prefixes'	=>	Array('lang','emailevents_List'), 'format'	=>	"#lang_status# '#lang_titlefield#' - !la_title_EmailEvents!"),

												'event_edit' 				=>	Array(	'prefixes' 				=>	Array('emailevents'),
																						'edit_status_labels'	=>	Array('emailevents'	=>	'!la_title_Editing_EmailEvent!'),
																						'format' 				=> 	'#emailevents_status# - #emailevents_titlefield#'),

												'email_messages_edit'		=>	Array(	'prefixes'	=>	Array('lang','emailevents'),
																						'format'	=>	"#lang_status# '#lang_titlefield#' - !la_title_EditingEmailEvent! '#emailevents_titlefield#'"),

												// for separate language list
												'languages_list_st' => Array ('prefixes' => Array ('lang_List'), 'format' => "!la_title_LanguagesManagement!"),
											),
					'EditTabPresets' => Array (
						'Default' => Array (
							'general' => Array ('title' => 'la_tab_General', 't' => 'regional/languages_edit', 'priority' => 1),
							'labels' => Array ('title' => 'la_tab_Labels', 't' => 'regional/languages_edit_phrases', 'priority' => 2),
							'email_events' => Array ('title' => 'la_tab_EmailEvents', 't' => 'regional/languages_edit_email_events', 'priority' => 3),
						),
					),

					'PermSection'		=>	Array('main' => 'in-portal:configure_lang'),

					'Sections' => Array (
						'in-portal:configure_lang' => Array (
							'parent'		=>	'in-portal:website_setting_folder',
							'icon'			=>	'conf_regional',
							'label'			=>	'la_tab_Regional',
							'url'			=>	Array('t' => 'regional/languages_list', 'pass' => 'm'),
							'permissions'	=>	Array('view', 'add', 'edit', 'delete', 'advanced:set_primary', 'advanced:import', 'advanced:export'),
							'priority'		=>	4,
							'type'			=>	stTREE,
						),

						// "Lang. Management"
						/*'in-portal:lang_management' => Array (
							'parent'		=>	'in-portal:system',
							'icon'			=>	'core:settings_general',
							'label'			=>	'la_title_LangManagement',
							'url'			=>	Array ('t' => 'languages/language_list', 'pass' => 'm'),
							'permissions'	=>	Array ('view', 'add', 'edit', 'delete'),
							'perm_prefix'	=>	'lang',
							'priority'		=>	10.03,
							'show_mode'		=>	smSUPER_ADMIN,
							'type'			=>	stTREE,
						),*/
					),

					'TableName'			=>	TABLE_PREFIX.'Language',

					'FilterMenu'		=>	Array(
												'Groups' => Array(
													Array('mode' => 'AND', 'filters' => Array(0,1), 'type' => WHERE_FILTER),
												),

												'Filters' => Array(
													0	=>	Array('label' =>'la_Enabled', 'on_sql' => '', 'off_sql' => '%1$s.Enabled != 1' ),
													1	=>	Array('label' => 'la_Disabled', 'on_sql' => '', 'off_sql' => '%1$s.Enabled != 0'  ),
												)
											),

					'AutoDelete'		=>	true,

					'AutoClone'			=>	true,

					'ListSQLs'			=>	Array(	''=>'SELECT * FROM %s',
																		), // key - special, value - list select sql
					'ItemSQLs'			=>	Array(	''=>'SELECT * FROM %s',
																		),
					'ListSortings' => Array (
						'' => Array (
							'Sorting' => Array ('Priority' => 'desc', 'PackName' => 'asc'),
						),
					),

					'Fields' => Array(
										'LanguageId' => Array('type' => 'int', 'not_null' => 1, 'default' => 0),

										'PackName' => Array (
											'type' => 'string',
											'formatter'				=>	'kOptionsFormatter',
											'options_sql'			=>	'SELECT %s FROM '.TABLE_PREFIX.'Language ORDER BY PackName',
											'option_title_field'	=>	'PackName',
											'option_key_field'		=>	'PackName',
											'not_null' => 1, 'required' => 1, 'default' => ''
										),
										'LocalName' => Array (
											'type' => 'string',
											'formatter'				=>	'kOptionsFormatter',
											'options_sql'			=>	'SELECT %s FROM '.TABLE_PREFIX.'Language ORDER BY PackName',
											'option_title_field'	=>	'LocalName',
											'option_key_field'		=>	'LocalName',
											'not_null' => 1, 'required' => 1, 'default' => ''
										),
										'Enabled' => Array(
											'type' => 'int',
											'formatter' => 'kOptionsFormatter',
											'options' => Array(
												0 => 'la_Disabled',
												1 => 'la_Active',
											),
											'use_phrases' => 1, 'not_null' => 1, 'default' => 1,
										),
										'PrimaryLang' => Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 0),
										'AdminInterfaceLang' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 0),
    									'Priority' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
										'IconURL' => Array ('type' => 'string', 'max_len' => 255, 'default' => NULL),
										'IconDisabledURL' => Array ('type' => 'string', 'max_len' => 255, 'default' => NULL),
										'DateFormat' => Array('type' => 'string','not_null' => '1','default' => '','required'=>1),
										'TimeFormat' => Array('type' => 'string','not_null' => '1','default' => '','required'=>1),
										'InputDateFormat' => Array('type' => 'string', 'formatter' => 'kOptionsFormatter', 'options' => Array('m/d/Y' => 'mm/dd/yyyy', 'd/m/Y' => 'dd/mm/yyyy', 'm.d.Y' => 'mm.dd.yyyy', 'd.m.Y' => 'dd.mm.yyyy'),  'not_null' => '1','default' => 'm/d/Y', 'required' => 1),
      									'InputTimeFormat' => Array('type' => 'string', 'formatter' => 'kOptionsFormatter', 'options' => Array('g:i:s A' => 'g:i:s A', 'g:i A' => 'g:i A', 'H:i:s' => 'H:i:s', 'H:i' => 'H:i' ), 'not_null' => '1','default' => 'g:i:s A', 'required' => 1),
										'DecimalPoint' => Array('type' => 'string','not_null' => 1, 'required' => 1, 'default' => ''),
										'ThousandSep' => Array('type' => 'string','not_null' => 1, 'default' => ''),
										'Charset' => Array('type' => 'string','not_null' => '1','default' => '','required'=>1),
										'UnitSystem' => Array('type' => 'int','not_null' => 1, 'default' => 1, 'formatter' => 'kOptionsFormatter','options' => Array(1 => 'la_Metric', 2 => 'la_US_UK'),'use_phrases' => 1),
										'FilenameReplacements' => Array ('type' => 'string', 'default' => NULL),
										'Locale' => Array('type' => 'string','not_null' => 1, 'default' => 'en-US', 'formatter' => 'kOptionsFormatter',
														  'options' => Array('' => ''),
														  'options_sql' => "SELECT CONCAT(LocaleName, ' ' ,'\/',Locale,'\/') AS name, Locale FROM ".TABLE_PREFIX."LocalesList ORDER BY LocaleId", 'option_title_field' => "name", 'option_key_field' => 'Locale',
										),
										'UserDocsUrl' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
								),

					'VirtualFields'	=> 	Array(
												'CopyLabels'		=>	Array('type' => 'int', 'default' => 0),
												'CopyFromLanguage'	=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options_sql' => 'SELECT %s FROM '.TABLE_PREFIX.'Language ORDER BY PackName', 'option_title_field' => 'PackName', 'option_key_field' => 'LanguageId'),
										),

					'Grids'	=> Array(
						'Default' => Array (
							'Icons' => Array (
								'default' => 'icon16_item.png',
								'0_0' => 'icon16_disabled.png',
								'0_1' => 'icon16_disabled.png',
								'1_0' => 'icon16_item.png',
								'1_1' => 'icon16_primary.png',
							),
							'Fields' => Array(
								'LanguageId' => Array ('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 50, ),
								'PackName' => Array ('title' => 'la_col_PackName', 'filter_block' => 'grid_options_filter', 'width' => 150, ),//
								'PrimaryLang' => Array ('title' => 'la_col_IsPrimaryLanguage', 'filter_block' => 'grid_options_filter', 'width' => 150, ),
								'AdminInterfaceLang' => Array ('title' => 'la_col_AdminInterfaceLang', 'filter_block' => 'grid_options_filter', 'width' => 150, ),
								'Charset' => Array ('title' => 'la_col_Charset', 'filter_block' => 'grid_like_filter', 'width' => 100, ),
								'Priority' => Array ('title' => 'la_col_Priority', 'filter_block' => 'grid_like_filter', 'width' => 60, ),
								'Enabled' => Array ('title' => 'la_col_Status', 'filter_block' => 'grid_options_filter', 'width' => 60, ),
							),
						),

						/*'LangManagement' => Array (
							'Icons' => Array (
								'default' => 'icon16_item.png',
								'0_0' => 'icon16_disabled.png',
								'0_1' => 'icon16_disabled.png',
								'1_0' => 'icon16_item.png',
								'1_1' => 'icon16_primary.png',
							),
							'Fields' => Array (
								'LanguageId' => Array ('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60),
								'PackName' => Array ('title' => 'la_col_Language', 'filter_block' => 'grid_options_filter', 'width' => 120),
								'LocalName' => Array ('title' => 'la_col_Prefix', 'filter_block' => 'grid_options_filter', 'width' => 120),
								'IconURL' => Array ('title' => 'la_col_Image', 'filter_block' => 'grid_empty_filter', 'width' => 80),
							),
						),*/
					),
	);