<?php
/**
* @version	$Id: site_config_tp.php 12871 2009-11-03 14:17:09Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class SiteConfigTagProcessor extends kTagProcessor {

		function PrintEditingModes($params)
		{
			$editing_modes = Array (
				EDITING_MODE_BROWSE => Array ('image' => 'browse_site_mode', 'title' => 'la_btn_BrowseMode'),
				EDITING_MODE_CONTENT => Array ('image' => 'content_mode', 'title' => 'la_btn_ContentMode'),
				EDITING_MODE_DESIGN => Array ('image' => 'design_mode', 'title' => 'la_btn_DesignMode'),
			);

			$site_config_helper =& $this->Application->recallObject('SiteConfigHelper');
			/* @var $site_config_helper SiteConfigHelper */

			$settings = $site_config_helper->getSettings();

			foreach ($editing_modes as $editing_mode => $data) {
				if (!in_array($editing_mode, $settings['visible_editing_modes'])) {
					unset($editing_modes[$editing_mode]);
				}
			}

			if (count($editing_modes) == 1) {
				// don't show buttons, when there only one left
				return '';
			}

			$ret = '';
			$i = 1;
			$count = count($editing_modes);
			$block_params = Array ('name' => $params['render_as']);

			foreach ($editing_modes as $editing_mode => $data) {
				$block_params = array_merge($block_params, $data);
				$block_params['editing_mode'] = $editing_mode;
				$block_params['is_last'] = $i == $count;

				$ret .= $this->Application->ParseBlock($block_params);
				$i++;
			}

			return $ret;
		}
	}