<?php
/**
* @version	$Id: phrases_config.php 13591 2010-05-19 17:52:27Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'phrases',

		'Clones' => Array (
			'phrases-single' => Array (
				'ForeignKey' => false,
				'ParentTableKey' => false,
				'ParentPrefix' => false,

				'Sections' => Array (
					// "Phrases"
					'in-portal:phrases' => Array (
						'parent'		=>	'in-portal:site',
						'icon'			=>	'phrases_labels',
						'label'			=>	'la_title_Phrases',
						'url'			=>	Array ('t' => 'languages/phrase_list', 'pass' => 'm'),
						'permissions'	=>	Array ('view', 'add', 'edit', 'delete'),
//						'perm_prefix'	=>	'lang',
						'priority'		=>	4,
//						'show_mode'		=>	smSUPER_ADMIN,
						'type'			=>	stTREE,
					),
				),
			)
		),

		'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'PhrasesEventHandler', 'file' => 'phrases_event_handler.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'PhraseTagProcessor', 'file' => 'phrase_tp.php', 'build_event' => 'OnBuild'),

		'AutoLoad' => true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'page',
			3 => 'event',
			4 => 'label',
			5 => 'mode', // labels can be edited directly
		),

		'IDField' => 'PhraseId',
		'TitleField' => 'Phrase',

		'TitlePresets' => Array (
			'default' => Array (
				'new_status_labels' => Array ('phrases' => '!la_title_Adding_Phrase!'),
				'edit_status_labels' => Array ('phrases' => '!la_title_Editing_Phrase!'),
			),

			'phrase_edit' => Array (
				'prefixes' => Array ('phrases'), 'format' => '#phrases_status# #phrases_titlefield#',
				'toolbar_buttons' => Array ('select', 'cancel', 'reset_edit', 'prev', 'next'),
				),

			// for separate phrases list
			'phrases_list_st' => Array (
				'prefixes' => Array ('phrases.st_List'), 'format' => "!la_title_Phrases!",
				'toolbar_buttons' => Array ('new_item', 'edit', 'delete', 'view', 'dbl-click'),
				),

			'phrase_edit_single' => Array (
				'prefixes' => Array ('phrases'), 'format' => '#phrases_status# #phrases_titlefield#',
				'toolbar_buttons' => Array ('select', 'cancel', 'reset_edit', 'prev', 'next'),
				),
		),

		'FilterMenu' => Array (
			'Groups' => Array (
				Array ('mode' => 'AND', 'filters' => Array ('show_front', 'show_admin', 'show_both'), 'type' => WHERE_FILTER),
				Array ('mode' => 'AND', 'filters' => Array ('translated', 'not_translated'), 'type' => WHERE_FILTER),
			),
			'Filters' => Array (
				'show_front' => Array ('label' =>'la_PhraseType_Front', 'on_sql' => '', 'off_sql' => '%1$s.PhraseType != 0'),
				'show_admin' => Array ('label' => 'la_PhraseType_Admin', 'on_sql' => '', 'off_sql' => '%1$s.PhraseType != 1'),
				'show_both' => Array ('label' => 'la_PhraseType_Both', 'on_sql' => '', 'off_sql' => '%1$s.PhraseType != 2'),
				's1' => Array (),
				'translated' => Array ('label' => 'la_PhraseTranslated', 'on_sql' => '', 'off_sql' => '%1$s.Translation = pri.Translation'),
				'not_translated' => Array ('label' => 'la_PhraseNotTranslated', 'on_sql' => '', 'off_sql' => '%1$s.Translation != pri.Translation'),
			)
		),

		'TableName' => TABLE_PREFIX . 'Phrase',

		'CalculatedFields' => Array (
			'' => Array (
				'PrimaryTranslation' => 'pri.Translation',
			),

			'st' => Array (
				'PackName' => 'lang.PackName',
			),
		),

		'ListSQLs' => Array(
			'' => '	SELECT %1$s.* %2$s
					FROM %1$s
					LEFT JOIN ' . TABLE_PREFIX . 'Phrase pri ON (%1$s.Phrase = pri.Phrase) AND (pri.LanguageId = 1)',
			'st' => 'SELECT %1$s.* %2$s
    				FROM %1$s
    				LEFT JOIN ' . TABLE_PREFIX . 'Language lang ON (%1$s.LanguageId = lang.LanguageId)',
		),

		'ListSortings' => Array (
			'' => Array (
				'Sorting' => Array ('Phrase' => 'asc'),
			)
		),

		'ForeignKey' => 'LanguageId',
		'ParentTableKey' => 'LanguageId',
		'ParentPrefix' => 'lang',
		'AutoDelete' => true,
		'AutoClone' => true,

		'Fields' => Array (
            'Phrase' => Array (
            	'type' => 'string',
            	'formatter' => 'kFormatter', 'regexp' => '/^(la|lu)_[A-Z\d:_\-\.]+$/i', 'unique' => Array ('LanguageId'),
            	'not_null' => 1, 'required' => 1, 'default' => '',
            ),
			'PhraseKey' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
            'Translation' => Array ('type' => 'string', 'formatter' => 'kFormatter', 'required' => 1, 'using_fck' => 1, 'default' => NULL),
            'PhraseType' => Array (
            	'type' => 'int',
            	'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'la_PhraseType_Front', 1 => 'la_PhraseType_Admin', 2 => 'la_PhraseType_Both'), 'use_phrases' => 1,
            	'not_null' => 1, 'required' => 1, 'default' => 0,
            ),
            'PhraseId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),

            'LanguageId' => Array (
            	'type' => 'int',
            	'formatter' => 'kOptionsFormatter', 'options_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'Language ORDER BY LocalName', 'option_key_field' => 'LanguageId', 'option_title_field' => 'LocalName',
            	'not_null' => 1, 'default' => 0,
            ),

            'LastChanged' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => NULL),
			'LastChangeIP' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
			'Module' => Array (
				'type' => 'string',
				'formatter' => 'kOptionsFormatter', 'options' => Array ('' => ''), 'options_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'Modules WHERE (Loaded = 1) AND (Name <> "In-Portal") ORDER BY LoadOrder', 'option_key_field' => 'Name', 'option_title_field' => 'Name',
				'not_null' => 1, 'default' => 'Core',
			),
        ),

		'VirtualFields' => Array (
			'PrimaryTranslation' => Array ('type' => 'string', 'default' => ''),
			'LangFile' => Array (
            	'type' => 'string',
            	'formatter' => 'kUploadFormatter',
            	'max_size' => MAX_UPLOAD_SIZE, 'upload_dir' => WRITEBALE_BASE . '/',
            	'max_len' => 255, 'default' => ''
			),
			'ImportOverwrite' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter',
				'options' => Array(
					0 => 'la_No',
					1 => 'la_Yes',
				),
				'use_phrases' => 1, 'not_null' => 1, 'default' => 0,
			),
			'DoNotEncode' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter',
				'options' => Array(
					0 => 'la_No',
					1 => 'la_Yes',
				),
				'use_phrases' => 1, 'not_null' => 1, 'default' => 0,
			),
			'PackName' => Array (
				'type' => 'string',
				'formatter' => 'kOptionsFormatter',
				'options_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'Language ORDER BY PackName', 'option_title_field' => 'PackName', 'option_key_field' => 'PackName',
			),
		),

		'Grids'	=> Array (
			'Default' => Array (
				'Icons' => Array (
					'default' => 'icon16_item.png',
					0 => 'icon16_disabled.png',
					1 => 'icon16_item.png',
				),
				'Fields' => Array (
					'PhraseId' => Array ('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 50),
					'Phrase' => Array ('title' => 'la_col_Label', 'data_block' => 'grid_checkbox_td', 'width' => 200),
					'Translation' => Array ('title' => 'la_col_Phrase', 'width' => 200),
					'PrimaryTranslation' => Array ('title' => 'la_col_PrimaryValue', 'width' => 200),
					'PhraseType' => Array ('title' => 'la_col_PhraseType', 'filter_block' => 'grid_options_filter', 'width' => 60),
					'LastChanged' => Array ('title' => 'la_col_Modified', 'filter_block' => 'grid_date_range_filter', 'width' => 150),
					'Module' => Array ('title' => 'la_col_Module', 'filter_block' => 'grid_options_filter', 'width' => 100),
				),
			),

			'Phrases' => Array (
				'Icons' => Array (
					'default' => 'icon16_item.png',
					0 => 'icon16_disabled.png',
					1 => 'icon16_item.png',
				),
				'Fields' => Array (
					'PhraseId' => Array ('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 50),
					'Phrase' => Array ('title' => 'la_col_Label', 'filter_block' => 'grid_like_filter', 'width' => 170),
					'Translation' => Array ('title' => 'la_col_Phrase', 'filter_block' => 'grid_like_filter', 'width' => 180),
					'PackName' => Array ('title' => 'la_col_Language', 'filter_block' => 'grid_options_filter', 'width' => 95),
					'PhraseType' => Array ('title' => 'la_col_Location', 'filter_block' => 'grid_options_filter', 'width' => 80),
					'LastChanged' => Array ('title' => 'la_col_Modified', 'filter_block' => 'grid_date_range_filter', 'width' => 145),
					'Module' => Array ('title' => 'la_col_Module', 'filter_block' => 'grid_options_filter', 'width' => 100),
				),
			),
		),
	);