<?php
/**
* @version	$Id: country_states_helper.php 12734 2009-10-20 19:28:11Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class kCountryStatesHelper extends kHelper
	{
		var $CountriesWithStates = Array('USA', 'CAN');

		function CountryHasStates($country_code)
		{
			return !$country_code ? false : in_array($country_code,$this->CountriesWithStates);
		}

		/**
		 * Prepares states dropdown based on country selected
		 *
		 * @param kEvent $event
		 * @param string $state_field
		 * @param string $country_field
		 */
		function PopulateStates(&$event, $state_field, $country_field)
		{
			static $country_states = Array ();

			$object =& $event->getObject();
			$country_abbr = $object->GetDBField($country_field);

			if (!$country_abbr) {
				return ;
			}

			if (!array_key_exists($country_abbr, $country_states)) {
				$sql = 'SELECT DestId
						FROM '.TABLE_PREFIX.'StdDestinations
						WHERE DestType = 1 AND DestAbbr = '.$this->Conn->qstr($country_abbr);
				$country_id = $this->Conn->GetOne($sql);
				if (!$country_id) {
					return ;
				}

				$sql = 'SELECT p.Translation as DestName, sd.DestAbbr
						FROM ' . TABLE_PREFIX . 'StdDestinations AS sd
						LEFT JOIN ' . TABLE_PREFIX . 'Phrase AS p ON p.Phrase = sd.DestName
						WHERE DestType = 2 AND DestParentId = ' . $country_id . ' AND LanguageId = ' . $this->Application->GetVar('m_lang') . '
						ORDER BY Translation';

				$country_states[$country_abbr] = $this->Conn->GetCol($sql, 'DestAbbr');
			}

			$object->Fields[$state_field]['options'] = $country_states[$country_abbr];
			$object->Fields[$state_field]['options'][''] = '';
		}

		/**
		 * Returns valid state code for state name and country code passed
		 *
		 * @param string $state_name
		 * @param string $country_code
		 * @return string
		 */
		function CheckState($state_name, $country_code)
		{
			if( !$this->CountryHasStates($country_code) ) return $state_name;

			$sql = 'SELECT sdStates.DestAbbr
					FROM '.TABLE_PREFIX.'StdDestinations AS sdStates
					LEFT JOIN '.TABLE_PREFIX.'Phrase AS p ON p.Phrase = sdStates.DestName
					LEFT JOIN '.TABLE_PREFIX.'StdDestinations AS sdCountries ON sdStates.DestParentId = sdCountries.DestId
					WHERE	(sdStates.DestType = 2) AND
							(sdStates.DestParentId = sdCountries.DestId) AND
							(p.LanguageId = %1$s) AND
							(sdCountries.DestAbbr = %2$s) AND
								(
									(LOWER(sdStates.DestAbbr) = %3$s) OR (LOWER(sdStates.DestAbbr2) = %3$s) OR (LOWER(sdStates.DestName)  = %3$s) OR (LOWER(p.Translation) = %3$s)
								)';

			$state_name = trim( mb_strtolower($state_name) );

			$sql = sprintf($sql, (int)$this->Application->GetVar('m_lang'), $this->Conn->qstr($country_code), $this->Conn->qstr($state_name) );

			return $this->Conn->GetOne($sql);
		}

		function CheckStateField(&$event, $state_field, $country_field)
		{

			$items_info = $this->Application->GetVar( $event->getPrefixSpecial(true) );
			if($items_info)
			{
				list($id, $field_values) = each($items_info);
				if( isset($field_values[$state_field]) && isset($field_values[$country_field]) )
				{
					$user_state = getArrayValue($field_values,$state_field);
					$valid_state = $this->CheckState($user_state, getArrayValue($field_values,$country_field) );
					if($valid_state !== false)
					{
						$field_values[$state_field] = $valid_state;
						$items_info[$id] = $field_values;
						$this->Application->SetVar( $event->getPrefixSpecial(true), $items_info);
					}
					else
					{
						$object =& $event->getObject();
						$object->Fields[$state_field]['options'][$user_state] = $user_state;
						$object->SetError($state_field, 'invalid_state', 'la_invalid_state');
					}
				}
			}
		}
	}