<?php
/**
* @version	$Id: email_message_tp.php 12734 2009-10-20 19:28:11Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class EmailMessageTagProcessor extends kDBTagProcessor {

		function PrintRecipients($params)
		{
			$recipient_type = $this->Application->RecallVar('recipient_type');

			$block_params = $this->prepareTagParams($params);
			$block_params['name'] = $params['render_as'];

			$recipients = $this->getRecipients($recipient_type);
			$recipient_count = count($recipients);
			$ret = '';

			foreach ($recipients as $recipient_index => $recipient_name) {
				$block_params['recipient_name'] = $recipient_name;
				$block_params['not_last'] = $recipient_index < $recipient_count - 1;

				$ret .= $this->Application->ParseBlock($block_params);
			}

			return $ret;
		}

		function getRecipients($prefix)
		{
			$id_field = $this->Application->getUnitOption($prefix, 'IDField');
			$table_name = $this->Application->getUnitOption($prefix, 'TableName');
			$recipient_ids = $this->Application->RecallVar('recipient_ids');

			$sql = 'SELECT '.($prefix == 'u' ? 'Email' : 'Name').'
					FROM '.$table_name.'
					WHERE '.$id_field.' IN ('.$recipient_ids.')';
			return $this->Conn->GetCol($sql);
		}

		/**
		 * Removes "Enabled" column, when not in debug mode
		 *
		 * @param Array $params
		 */
		function ModifyUnitConfig($params)
		{
			if (!$this->Application->isDebugMode()) {
				$grids = $this->Application->getUnitOption($this->Prefix, 'Grids');

				foreach ($grids as $grid_name => $grid_data) {
					if (array_key_exists('Enabled', $grid_data['Fields'])) {
						unset($grids[$grid_name]['Fields']['Enabled']);
					}
				}

				$this->Application->setUnitOption($this->Prefix, 'Grids', $grids);
			}
		}
	}