<?php
/**
* @version	$Id: custom_fields_helper.php 13545 2010-05-11 19:19:58Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	/**
	 * Enter description here...
	 *
	 * @todo rewrite
	 */
	class InpCustomFieldsHelper extends kHelper {

		/**
		 * Parses given option string and returns associative array
		 *
		 * @param string $values_list
		 * @param string $separator
		 * @param bool $parse
		 * @return Array
		 */
		function GetValuesHash($values_list, $separator = VALUE_LIST_SEPARATOR, $parse = true)
		{
			$values_list = trim($this->ParseConfigSQL($values_list, $separator, $parse), $separator);

			if (!$values_list) {
				// no options, then return empty array
				return Array();
			}

			$optionValuesTmp = explode($separator, $values_list);
			$optionValues = Array();

			if (substr_count($values_list, '=') != count($optionValuesTmp)) {
				if ($this->Application->isDebugMode()) {
					$this->Application->Debugger->appendTrace();
				}

				trigger_error('Invalid symbol in ValueList field [' . substr($values_list, 0, 100) . ' ...]' , E_USER_NOTICE);
				return Array ();
			}

			if ($parse) {
				// normal way
				foreach ($optionValuesTmp as $optionValue) {
					list ($key, $val) = explode('=', $optionValue);

					$val = substr($val, 0, 1) == '+' ? substr($val, 1) : $this->Application->Phrase($val);

					$optionValues[$key] = $val;
				}
			}
			else {
				// during custom field editing
				foreach ($optionValuesTmp as $optionValue) {
					list ($key, $val) = explode('=', $optionValue);

					if (substr($key, 0, 3) == 'SQL') {
						$val = base64_decode( str_replace('_', '=', substr($val, 1)) );
					}

					$optionValues[$key] = $val;
				}
			}

			return $optionValues;
		}

		/**
		 * Replace SQL's in valueList with appropriate queried values
		 *
		 * @param string $valueString
		 * @param string $separator
		 * @return string
		 * @todo Apply refactoring to embedded vars stuff
		 */
		function ParseConfigSQL($valueString, $separator = VALUE_LIST_SEPARATOR, $parse_sqls = true)
		{
			if ($parse_sqls) {
				$string = trim( str_replace(Array('<PREFIX>', '%3$s'), Array (TABLE_PREFIX, $this->Application->GetVar('m_lang')), $valueString) );
			}
			else {
				$string = $valueString;
			}

			if (preg_match_all('/<SQL([+]{0,1})>(.*?)<\/SQL>/', $string, $regs)) {
				$i = 0;
				$sql_count = count($regs[0]);
				while ($i < $sql_count) {
					if ($parse_sqls) {
						$replacement = $this->_queryConfigSQL($regs[2][$i], $regs[1][$i], $separator);
					}
					else {
						$sql = base64_encode('<SQL'.$regs[1][$i].'>'.$regs[2][$i].'</SQL>');
						$replacement = 'SQL' . $i . '=+' . str_replace('=', '_', $sql);
					}

					$string = str_replace('<SQL'.$regs[1][$i].'>'.$regs[2][$i].'</SQL>', $replacement, $string);
					$i++;
				}

				$string = preg_replace('/[' . preg_quote($separator, '/') . ']+/', $separator, $string); // trim trailing separators inside string
			}

			return $string;
		}

		/**
		 * Transforms given sql into value list string
		 *
		 * @param string $sql
		 * @param string $plus
		 * @param string $separator
		 * @return string
		 */
		function _queryConfigSQL($sql, $plus = '', $separator = VALUE_LIST_SEPARATOR)
		{
			$values = $this->Conn->Query($sql);
			foreach ($values as $index => $value) {
				$values[$index] = $value['OptionValue'] . '=' . $plus . $value['OptionName'];
			}

			return implode($separator, $values);
		}
	}