<?php
/**
* @version	$Id: theme_item.php 13559 2010-05-12 09:36:46Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class ThemeItem extends kDBItem
	{
		function Load($id, $id_field_name=null)
		{
			$default = false;
			if ($id == 'default') {
				// domain based primary theme
				$id = $this->Application->siteDomainField('PrimaryThemeId');

				if (!$id) {
					$id = 1;
					$id_field_name = 'PrimaryTheme';
				}

				$default = true;
			}

			$res = parent::Load($id, $id_field_name, true);

			if ($res) {
				$available_themes = $this->Application->siteDomainField('Themes');

				if ($available_themes) {
					if (strpos($available_themes, '|' . $this->GetID() . '|') === false) {
						// theme isn't allowed in site domain
						return $this->Clear();
					}
				}
			}

			if ($default) {
				if (!$res) {
					if ($this->Application->isAdmin) {
						$res = parent::Load(1);
					}
				}
				$this->Application->SetVar('theme.current_id', $this->GetID() );
				$this->Application->SetVar('m_theme', $this->GetID() );
			}

			return $res;
		}
	}