<?php
/**
* @version	$Id: site_helper.php 13559 2010-05-12 09:36:46Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2010 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class SiteHelper extends kHelper {

		/**
		 * Returns default country
		 *
		 * @return string
		 */
		function getDefaultCountry($country_prefix = '', $iso_format = true)
		{
			$country = $this->Application->siteDomainField($country_prefix . 'Country');

			if ($iso_format && !$country) {
				$country = 'USA';
			}

			if (!$iso_format && strlen($country)) {
				return $this->getCountryId($country);
			}

			return $country;
		}

		/**
		 * Returns country id based on it's ISO code
		 *
		 * @param string $iso_code
		 * @return int
		 */
		function getCountryId($iso_code)
		{
			static $cache = null;

			if (!isset($cache)) {
				$sql = 'SELECT CountryStateId, IsoCode
						FROM ' . $this->Application->getUnitOption('country-state', 'TableName') . '
						WHERE Type = ' . DESTINATION_TYPE_COUNTRY;
				$cache = $this->Conn->GetCol($sql, 'IsoCode');
			}

			return $cache[$iso_code];
		}
	}
