<?php
/**
* @version	$Id: phrase_tp.php 12734 2009-10-20 19:28:11Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	class PhraseTagProcessor extends kDBTagProcessor {

		/**
		 * Determines, that hidden field with language id should be shown
		 *
		 * @param Array $params
		 * @return bool
		 */
		function ShowHiddenLanguage($params)
		{
			$simple_mode = $this->Application->GetVar('simple_mode');
			$phrases_label = $this->Application->GetVar('phrases_label');

			return $simple_mode || !$phrases_label;
		}

		/**
		 * Determines, that we can close phrase editing form without parent window refreshing
		 *
		 * @param Array $params
		 * @return bool
		 */
		function UseQuickFormCancel($params)
		{
			return $this->Application->GetVar('simple_mode') && (int)$this->Application->ConfigValue('UsePopups');
		}
	}